/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.eclipse.scout.rt.ui.html.json.IJsonObjectFactory;
import org.eclipse.scout.rt.ui.html.json.JsonBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class MainJsonObjectFactory
implements IJsonObjectFactory {
    private static final Logger LOG = LoggerFactory.getLogger(MainJsonObjectFactory.class);
    private List<IJsonObjectFactory> m_factories;

    private List<IJsonObjectFactory> getFactories() {
        if (this.m_factories == null) {
            this.m_factories = this.createFactories();
            LOG.info("Using following object factories: {}", this.m_factories);
        }
        return this.m_factories;
    }

    private List<IJsonObjectFactory> createFactories() {
        ArrayList<IJsonObjectFactory> factories = new ArrayList<IJsonObjectFactory>();
        for (IJsonObjectFactory factory : BEANS.all(IJsonObjectFactory.class)) {
            if (factory == this) continue;
            factories.add(factory);
        }
        return factories;
    }

    @Override
    public IJsonAdapter<?> createJsonAdapter(Object model, IUiSession session, String id, IJsonAdapter<?> parent) {
        for (IJsonObjectFactory factory : this.getFactories()) {
            IJsonAdapter<?> adapter = factory.createJsonAdapter(model, session, id, parent);
            if (adapter == null) continue;
            return adapter;
        }
        throw new IllegalArgumentException("No factory found for model " + String.valueOf(model));
    }

    @Override
    public IJsonObject createJsonObject(Object object) {
        for (IJsonObjectFactory factory : this.getFactories()) {
            IJsonObject jsonObject = factory.createJsonObject(object);
            if (jsonObject == null) continue;
            return jsonObject;
        }
        return new JsonBean(object, this);
    }

    public static MainJsonObjectFactory get() {
        return (MainJsonObjectFactory)BEANS.get(MainJsonObjectFactory.class);
    }
}

