/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.rt.ui.html.json.JsonRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class JsonStartupRequest
extends JsonRequest {
    public static final String PROP_PART_ID = "partId";
    public static final String PROP_CLIENT_SESSION_ID = "clientSessionId";
    public static final String PROP_USER_AGENT = "userAgent";
    public static final String PROP_SESSION_STARTUP_PARAMS = "sessionStartupParams";
    public static final String PROP_VERSION = "version";
    private final Map<String, String> m_sessionStartupParams;

    public JsonStartupRequest(JsonRequest request) {
        super(request.getRequestObject());
        this.m_sessionStartupParams = this.parseSessionStartupParams(request.getRequestObject());
    }

    public String getPartId() {
        return this.getRequestObject().optString(PROP_PART_ID, "0");
    }

    public String getClientSessionId() {
        return this.getRequestObject().optString(PROP_CLIENT_SESSION_ID, null);
    }

    public JSONObject getUserAgent() {
        return this.getRequestObject().optJSONObject(PROP_USER_AGENT);
    }

    public String getVersion() {
        return this.getRequestObject().optString(PROP_VERSION, null);
    }

    public Map<String, String> getSessionStartupParams() {
        return this.m_sessionStartupParams;
    }

    protected Map<String, String> parseSessionStartupParams(JSONObject object) {
        JSONObject params = this.getRequestObject().optJSONObject(PROP_SESSION_STARTUP_PARAMS);
        if (params == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(params.length());
        JSONArray names = params.names();
        if (names != null) {
            int i = 0;
            while (i < names.length()) {
                String name = names.getString(i);
                map.put(name, params.optString(name, null));
                ++i;
            }
        }
        return Collections.unmodifiableMap(map);
    }
}

