/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.eclipse.scout.rt.ui.html.json.JsonPropertyChangeEvent;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonResponse {
    private static final Logger LOG = LoggerFactory.getLogger(JsonResponse.class);
    public static final int ERR_STARTUP_FAILED = 5;
    public static final int ERR_SESSION_TIMEOUT = 10;
    public static final int ERR_UI_PROCESSING = 20;
    public static final int ERR_UNSAFE_UPLOAD = 30;
    public static final int ERR_REJECTED_UPLOAD = 31;
    public static final int ERR_VERSION_MISMATCH = 40;
    public static final String PROP_SEQUENCE_NO = "#";
    public static final String PROP_COMBINED = "combined";
    public static final String PROP_EVENTS = "events";
    public static final String PROP_ADAPTER_DATA = "adapterData";
    public static final String PROP_STARTUP_DATA = "startupData";
    public static final String PROP_ERROR = "error";
    public static final String PROP_ERROR_CODE = "code";
    public static final String PROP_ERROR_MESSAGE = "message";
    private final Long m_sequenceNo;
    private final Map<String, IJsonAdapter<?>> m_adapterMap;
    private final List<JsonEvent> m_eventList;
    private final Map<String, JsonPropertyChangeEvent> m_idToPropertyChangeEventMap;
    private final Set<IJsonAdapter<?>> m_bufferedEventsAdapters;
    private volatile JSONObject m_startupData = null;
    private volatile boolean m_error;
    private volatile int m_errorCode;
    private volatile String m_errorMessage;
    private volatile boolean m_writable = true;
    private volatile boolean m_processingBufferedEvents;

    public JsonResponse() {
        this(null);
    }

    public JsonResponse(Long sequenceNo) {
        this.m_sequenceNo = sequenceNo;
        this.m_adapterMap = new HashMap();
        this.m_eventList = new ArrayList<JsonEvent>();
        this.m_idToPropertyChangeEventMap = new HashMap<String, JsonPropertyChangeEvent>();
        this.m_bufferedEventsAdapters = new LinkedHashSet();
    }

    public Long getSequenceNo() {
        return this.m_sequenceNo;
    }

    public void addAdapter(IJsonAdapter<?> adapter) {
        this.assertWritable();
        if (!this.m_adapterMap.containsKey(adapter.getId())) {
            this.m_adapterMap.put(adapter.getId(), adapter);
        }
    }

    public JsonEvent addPropertyChangeEvent(String id, String propertyName, Object newValue) {
        this.assertWritable();
        JsonPropertyChangeEvent event = this.m_idToPropertyChangeEventMap.get(id);
        if (event == null) {
            event = new JsonPropertyChangeEvent(id);
            this.m_eventList.add(event);
            this.m_idToPropertyChangeEventMap.put(id, event);
        }
        event.getProperties().put(propertyName, newValue);
        return event;
    }

    public JsonEvent addActionEvent(String eventTarget, String eventType) {
        this.assertWritable();
        return this.addActionEvent(eventTarget, eventType, null);
    }

    public JsonEvent addActionEvent(String eventTarget, String eventType, JSONObject eventData) {
        this.assertWritable();
        JsonEvent event = new JsonEvent(eventTarget, eventType, eventData);
        this.m_eventList.add(event);
        return event;
    }

    public JsonEvent addActionEvent(String eventTarget, String eventType, String eventReference, JSONObject eventData) {
        this.assertWritable();
        JsonEvent event = new JsonEvent(eventTarget, eventType, eventReference, eventData);
        this.m_eventList.add(event);
        return event;
    }

    public JsonEvent replaceActionEvent(String eventTarget, String eventType, JSONObject eventData) {
        this.assertWritable();
        this.m_eventList.removeIf(event -> ObjectUtility.equals((Object)event.getTarget(), (Object)eventTarget) && ObjectUtility.equals((Object)event.getType(), (Object)eventType));
        return this.addActionEvent(eventTarget, eventType, eventData);
    }

    public boolean containsAdapter(IJsonAdapter<?> adapter) {
        return this.m_adapterMap.containsKey(adapter.getId());
    }

    public boolean containsPropertyChangeEvent(String id, String propertyName) {
        for (JsonEvent event : this.m_eventList) {
            if (!event.getTarget().equals(id) || !(event instanceof JsonPropertyChangeEvent) || !((JsonPropertyChangeEvent)event).getProperties().containsKey(propertyName)) continue;
            return true;
        }
        return false;
    }

    public void registerBufferedEventsAdapter(IJsonAdapter<?> adapter) {
        this.assertWritable();
        if (this.m_processingBufferedEvents) {
            throw new IllegalStateException("Cannot register an adapter as buffered events provider while processing buffered events [" + String.valueOf(adapter) + "]");
        }
        if (adapter != null) {
            this.m_bufferedEventsAdapters.add(adapter);
        }
    }

    public void unregisterBufferedEventsAdapter(IJsonAdapter<?> adapter) {
        this.assertWritable();
        if (this.m_processingBufferedEvents) {
            throw new IllegalStateException("Cannot unregister an adapter as buffered events provider while processing buffered events [" + String.valueOf(adapter) + "]");
        }
        if (adapter != null) {
            this.m_bufferedEventsAdapters.remove(adapter);
        }
    }

    public void markAsStartupResponse() {
        this.assertWritable();
        this.m_startupData = new JSONObject();
    }

    public boolean isMarkedAsStartupResponse() {
        return this.m_startupData != null;
    }

    public JSONObject getStartupData() {
        return this.m_startupData;
    }

    public void markAsError(int errorCode, String errorMessage) {
        this.assertWritable();
        this.m_error = true;
        this.m_errorCode = errorCode;
        this.m_errorMessage = errorMessage;
    }

    public boolean isMarkedAsError() {
        return this.m_error;
    }

    public boolean isWritable() {
        return this.m_writable;
    }

    protected void assertWritable() {
        Assertions.assertTrue((boolean)this.m_writable, (String)"This JSON response was already sent to the UI and is no longer writable!", (Object[])new Object[0]);
    }

    public JSONObject toJson() {
        this.fireProcessBufferedEvents();
        this.m_writable = false;
        return this.toJsonInternal();
    }

    protected JSONObject toJsonInternal() {
        JSONObject adapterData = new JSONObject();
        LinkedList<String> adapterIds = null;
        for (Map.Entry<String, IJsonAdapter<?>> entry : this.m_adapterMap.entrySet()) {
            JSONObject adapterJson = entry.getValue().toJson();
            if (adapterJson == null) continue;
            JsonObjectUtility.filterDefaultValues(adapterJson);
            adapterData.put(entry.getKey(), (Object)adapterJson);
            if (!LOG.isDebugEnabled()) continue;
            if (adapterIds == null) {
                adapterIds = new LinkedList<String>();
            }
            adapterIds.add(entry.getValue().getId());
        }
        if (adapterIds != null) {
            LOG.debug("Adapter data created for these adapters: {}", adapterIds);
        }
        JSONArray eventArray = new JSONArray();
        for (JsonEvent event : this.m_eventList) {
            if (!this.doAddEvent(event)) continue;
            eventArray.put((Object)event.toJson());
        }
        JSONObject json = new JSONObject();
        json.put(PROP_SEQUENCE_NO, (Object)this.m_sequenceNo);
        json.put(PROP_STARTUP_DATA, (Object)this.m_startupData);
        json.put(PROP_ADAPTER_DATA, (Object)(adapterData.length() == 0 ? null : adapterData));
        json.put(PROP_EVENTS, (Object)(eventArray.length() == 0 ? null : eventArray));
        if (this.m_error) {
            JSONObject jsonError = new JSONObject();
            jsonError.put(PROP_ERROR_CODE, this.m_errorCode);
            jsonError.put(PROP_ERROR_MESSAGE, (Object)this.m_errorMessage);
            json.put(PROP_ERROR, (Object)jsonError);
        }
        return json;
    }

    public void fireProcessBufferedEvents() {
        this.assertWritable();
        this.m_processingBufferedEvents = true;
        try {
            for (IJsonAdapter<?> adapter : new ArrayList(this.m_bufferedEventsAdapters)) {
                if (adapter.isDisposed()) continue;
                adapter.processBufferedEvents();
            }
            this.m_bufferedEventsAdapters.clear();
        }
        finally {
            this.m_processingBufferedEvents = false;
        }
    }

    protected boolean doAddEvent(JsonEvent event) {
        return !this.m_adapterMap.containsKey(event.getTarget()) || event.isProtected();
    }

    public void removeJsonAdapter(String id) {
        this.assertWritable();
        IJsonAdapter<?> removedAdapter = this.m_adapterMap.remove(id);
        Iterator<JsonEvent> it = this.m_eventList.iterator();
        while (it.hasNext()) {
            JsonEvent event = it.next();
            if (ObjectUtility.equals((Object)event.getTarget(), (Object)id)) {
                it.remove();
                continue;
            }
            if (removedAdapter == null || event.getReference() == null || !ObjectUtility.equals((Object)event.getReference(), (Object)id)) continue;
            it.remove();
        }
        this.m_idToPropertyChangeEventMap.remove(id);
        this.m_bufferedEventsAdapters.removeIf(adapter -> ObjectUtility.equals((Object)adapter.getId(), (Object)id));
    }

    public List<JsonEvent> getEventList() {
        return CollectionUtility.arrayList(this.m_eventList);
    }

    protected List<JsonEvent> eventList() {
        return this.m_eventList;
    }

    protected Map<String, IJsonAdapter<?>> adapterMap() {
        return this.m_adapterMap;
    }

    protected JSONObject startupData() {
        return this.m_startupData;
    }

    protected boolean error() {
        return this.m_error;
    }

    protected int errorCode() {
        return this.m_errorCode;
    }

    protected String errorMessage() {
        return this.m_errorMessage;
    }

    public boolean isEmpty() {
        return this.m_adapterMap.isEmpty() && this.m_eventList.isEmpty() && this.m_bufferedEventsAdapters.isEmpty() && this.m_startupData == null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("JsonResponse [");
        if (this.m_sequenceNo != null) {
            sb.append(PROP_SEQUENCE_NO).append(this.m_sequenceNo).append(", ");
        }
        if (this.m_startupData != null) {
            sb.append("STARTUP RESPONSE, ");
        }
        sb.append("adapters: ").append(this.m_adapterMap.size()).append(", ");
        sb.append("events: ").append(this.m_eventList.size()).append(", ");
        sb.append("buffered events adapters: ").append(this.m_bufferedEventsAdapters.size());
        if (this.m_error) {
            sb.append(", MARKED AS ERROR ").append(this.m_errorCode).append(": ").append(this.m_errorMessage);
        }
        sb.append("]");
        return sb.toString();
    }
}

