/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ConnectionErrorDetector;
import org.eclipse.scout.rt.platform.util.IOUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruption;
import org.eclipse.scout.rt.ui.html.UiException;
import org.eclipse.scout.rt.ui.html.json.JsonResponse;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class JsonRequestHelper {
    private static final Logger LOG = LoggerFactory.getLogger(JsonRequestHelper.class);

    public JSONObject createUnrecoverableFailureResponse() {
        return this.createUnrecoverableFailureResponse(null);
    }

    public JSONObject createUnrecoverableFailureResponse(Long sequenceNo) {
        JsonResponse response = new JsonResponse(sequenceNo);
        response.markAsError(20, "UI processing error");
        return response.toJson();
    }

    public JSONObject createEmptyResponse() {
        return new JSONObject();
    }

    public JSONObject createUnsafeUploadResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsError(30, "Unsafe file upload.");
        return response.toJson();
    }

    public JSONObject createRejectedUploadResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsError(31, "Rejected file upload.");
        return response.toJson();
    }

    public JSONObject createSessionTimeoutResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsError(10, "The session has expired, please reload the page.");
        return response.toJson();
    }

    public JSONObject createStartupFailedResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsError(5, "Initialization failed");
        return response.toJson();
    }

    public JSONObject createVersionMismatchResponse() {
        JsonResponse response = new JsonResponse();
        response.markAsError(40, "Version mismatch");
        return response.toJson();
    }

    public JSONObject createPingResponse() {
        JSONObject json = new JSONObject();
        json.put("pong", (Object)Boolean.TRUE);
        return json;
    }

    public JSONObject createSessionTerminatedResponse(String redirectUrl) {
        JSONObject json = new JSONObject();
        json.put("sessionTerminated", (Object)Boolean.TRUE);
        if (StringUtility.hasText((CharSequence)redirectUrl)) {
            json.put("redirectUrl", (Object)redirectUrl);
        }
        return json;
    }

    public void writeResponse(ServletResponse servletResponse, JSONObject jsonResponse) throws IOException {
        String jsonText = jsonResponse.toString();
        byte[] data = jsonText.getBytes(StandardCharsets.UTF_8);
        servletResponse.setContentLength(data.length);
        if (servletResponse.getContentType() == null) {
            servletResponse.setContentType("application/json");
        }
        servletResponse.setCharacterEncoding(StandardCharsets.UTF_8.name());
        ThreadInterruption.IRestorer interruption = ThreadInterruption.clear();
        try {
            try {
                servletResponse.getOutputStream().write(data);
            }
            catch (Exception e) {
                if (((ConnectionErrorDetector)BEANS.get(ConnectionErrorDetector.class)).isConnectionError((Throwable)e)) {
                    LOG.debug("Connection Error: ", (Throwable)e);
                    interruption.restore();
                    return;
                }
                throw e;
            }
        }
        finally {
            interruption.restore();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Returned: {}", (Object)this.formatJsonForLogging(jsonText));
        } else if (LOG.isDebugEnabled()) {
            LOG.debug("Returned: {}", (Object)this.formatJsonResponseForLogging(jsonResponse));
        }
    }

    public JSONObject readJsonRequest(ServletRequest servletRequest) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader in = servletRequest.getReader();){
                JSONObject jsonRequest;
                String jsonData = IOUtility.readString((Reader)in);
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Received: {}", (Object)this.formatJsonForLogging(jsonData));
                }
                JSONObject jSONObject = jsonRequest = jsonData == null ? new JSONObject() : new JSONObject(jsonData);
                if (LOG.isDebugEnabled() && !LOG.isTraceEnabled()) {
                    LOG.debug("Received: {}", (Object)this.formatJsonRequestForLogging(jsonRequest));
                }
                return jsonRequest;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | RuntimeException e) {
            throw new UiException(e.getMessage(), e);
        }
    }

    protected String formatJsonForLogging(String jsonText) {
        if (LOG.isDebugEnabled() && !LOG.isTraceEnabled() && jsonText != null && jsonText.length() > 10000) {
            return jsonText.substring(0, 10000) + "...";
        }
        return jsonText;
    }

    protected String formatJsonResponseForLogging(JSONObject jsonResponse) {
        JSONObject o;
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (jsonResponse.has("#")) {
            list.add((CallSite)((Object)("#" + String.valueOf(jsonResponse.get("#")))));
        }
        if (jsonResponse.has("combined")) {
            list.add((CallSite)((Object)("combined: " + String.valueOf(jsonResponse.get("combined")))));
        }
        if (jsonResponse.has("error")) {
            list.add((CallSite)((Object)("error: " + String.valueOf(jsonResponse.get("error")))));
        }
        if (jsonResponse.has("startupData")) {
            o = jsonResponse.optJSONObject("startupData");
            list.add((CallSite)((Object)("startupData: " + (String)(o == null ? "(invalid)" : "{" + o.length() + "}"))));
        }
        if (jsonResponse.has("events")) {
            JSONArray a = jsonResponse.optJSONArray("events");
            list.add((CallSite)((Object)("events: " + (a == null ? "(invalid)" : this.formatEventTypesForLogging(a)))));
        }
        if (jsonResponse.has("adapterData")) {
            o = jsonResponse.optJSONObject("adapterData");
            list.add((CallSite)((Object)("adapterData: " + (String)(o == null ? "(invalid)" : "{" + o.length() + "}"))));
        }
        return CollectionUtility.format(list);
    }

    protected String formatJsonRequestForLogging(JSONObject jsonRequest) {
        ArrayList<CallSite> list = new ArrayList<CallSite>();
        if (jsonRequest.has("#")) {
            list.add((CallSite)((Object)("#" + String.valueOf(jsonRequest.get("#")))));
        }
        if (jsonRequest.has("#ACK")) {
            list.add((CallSite)((Object)("#ACK: " + String.valueOf(jsonRequest.get("#ACK")))));
        }
        if (jsonRequest.has("startup")) {
            list.add((CallSite)((Object)("startup: " + String.valueOf(jsonRequest.get("startup")))));
        }
        if (jsonRequest.has("unload")) {
            list.add((CallSite)((Object)("unload: " + String.valueOf(jsonRequest.get("unload")))));
        }
        if (jsonRequest.has("log")) {
            list.add((CallSite)((Object)("log: " + String.valueOf(jsonRequest.get("log")))));
        }
        if (jsonRequest.has("pollForBackgroundJobs")) {
            list.add((CallSite)((Object)("pollForBackgroundJobs: " + String.valueOf(jsonRequest.get("pollForBackgroundJobs")))));
        }
        if (jsonRequest.has("cancel")) {
            list.add((CallSite)((Object)("cancel: " + String.valueOf(jsonRequest.get("cancel")))));
        }
        if (jsonRequest.has("ping")) {
            list.add((CallSite)((Object)("ping: " + String.valueOf(jsonRequest.get("ping")))));
        }
        if (jsonRequest.has("syncResponseQueue")) {
            list.add((CallSite)((Object)("syncResponseQueue: " + String.valueOf(jsonRequest.get("syncResponseQueue")))));
        }
        if (jsonRequest.has("events")) {
            JSONArray a = jsonRequest.optJSONArray("events");
            list.add((CallSite)((Object)("events: " + (a == null ? "(invalid)" : this.formatEventTypesForLogging(a)))));
        }
        if (jsonRequest.has("uiSessionId")) {
            list.add((CallSite)((Object)("uiSessionId: " + String.valueOf(jsonRequest.get("uiSessionId")))));
        }
        return CollectionUtility.format(list);
    }

    protected String formatEventTypesForLogging(JSONArray events) {
        ArrayList<Object> types = new ArrayList<Object>();
        if (events != null) {
            int i = 0;
            while (i < events.length()) {
                JSONObject event = events.optJSONObject(i);
                if (event != null && event.has("type")) {
                    types.add(String.valueOf(event.get("type")));
                } else {
                    types.add("?");
                }
                ++i;
            }
        }
        return "[" + CollectionUtility.format(types) + "]";
    }
}

