/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.stream.Collector;
import java.util.stream.IntStream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.reflect.FastBeanInfo;
import org.eclipse.scout.rt.platform.reflect.FastPropertyDescriptor;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.ui.html.json.IDefaultValuesFilterService;
import org.eclipse.scout.rt.ui.html.json.JsonByteArray;
import org.eclipse.scout.rt.ui.html.json.JsonDate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonObjectUtility {
    private static final Logger LOG = LoggerFactory.getLogger(JsonObjectUtility.class);

    private JsonObjectUtility() {
    }

    public static String[] getNames(JSONObject source) {
        if (source == null || source.length() == 0) {
            return new String[0];
        }
        String[] names = new String[source.length()];
        int i = 0;
        Iterator it = source.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            names[i++] = key;
        }
        return names;
    }

    public static void putProperties(JSONObject target, JSONObject source) {
        if (target == null || source == null) {
            return;
        }
        String[] stringArray = JsonObjectUtility.getNames(source);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            target.put(prop, source.opt(prop));
            ++n2;
        }
    }

    public static void mergeProperties(JSONObject target, JSONObject source) {
        if (target == null || source == null) {
            return;
        }
        String[] stringArray = JsonObjectUtility.getNames(source);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String prop = stringArray[n2];
            Object newValue = source.opt(prop);
            Object oldValue = target.opt(prop);
            if (newValue instanceof JSONObject && oldValue instanceof JSONObject) {
                JsonObjectUtility.mergeProperties((JSONObject)oldValue, (JSONObject)newValue);
            } else {
                target.put(prop, newValue);
            }
            ++n2;
        }
    }

    public static Long optLong(JSONObject json, String propertyName) {
        long value2;
        if (json == null || propertyName == null) {
            return null;
        }
        long value = json.optLong(propertyName, -1L);
        if (value == -1L && (value2 = json.optLong(propertyName, -2L)) == -2L) {
            return null;
        }
        return value;
    }

    public static Double optDouble(JSONObject json, String propertyName) {
        double value2;
        if (json == null || propertyName == null) {
            return null;
        }
        double value = json.optDouble(propertyName, -1.0);
        if (value == -1.0 && (value2 = json.optDouble(propertyName, -2.0)) == -2.0) {
            return null;
        }
        return value;
    }

    public static Integer optInt(JSONObject json, String propertyName) {
        int value2;
        if (json == null || propertyName == null) {
            return null;
        }
        int value = json.optInt(propertyName, -1);
        if (value == -1 && (value2 = json.optInt(propertyName, -2)) == -2) {
            return null;
        }
        return value;
    }

    public static void putIfNotNull(JSONArray jsonArray, Object value) {
        if (jsonArray != null && value != null) {
            jsonArray.put(value);
        }
    }

    public static String toString(JSONObject json) {
        if (json == null) {
            return "null";
        }
        try {
            return json.toString(2);
        }
        catch (JSONException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected error while converting JSON to string", (Throwable)e);
            }
            return json.toString();
        }
    }

    public static <T> T jsonObjectPropertyToJava(JSONObject jsonObject, String propertyName, Class<T> type, boolean throwForMissingProperty) {
        Object jval = JsonObjectUtility.getTyped(jsonObject, propertyName, type);
        return JsonObjectUtility.jsonValueToJava(jval, type, throwForMissingProperty);
    }

    public static Map<String, Object> unwrap(JSONObject obj) {
        if (obj == null || obj == JSONObject.NULL) {
            return null;
        }
        return (Map)obj.keySet().stream().map(key -> new AbstractMap.SimpleImmutableEntry<String, Object>((String)key, JsonObjectUtility.unwrap(obj.opt(key)))).collect(StreamUtility.toMap(LinkedHashMap::new, Map.Entry::getKey, Map.Entry::getValue, (BiFunction)StreamUtility.throwingMerger(), (Collector.Characteristics[])new Collector.Characteristics[0]));
    }

    public static Object[] unwrap(JSONArray jsonArr) {
        if (jsonArr == null || jsonArr == JSONObject.NULL) {
            return null;
        }
        return IntStream.range(0, jsonArr.length()).mapToObj(arg_0 -> ((JSONArray)jsonArr).opt(arg_0)).map(JsonObjectUtility::unwrap).toArray();
    }

    public static Object unwrap(Object o) {
        if (o == null || o == JSONObject.NULL) {
            return null;
        }
        if (o instanceof JSONObject) {
            return JsonObjectUtility.unwrap((JSONObject)o);
        }
        if (o instanceof JSONArray) {
            return JsonObjectUtility.unwrap((JSONArray)o);
        }
        return o;
    }

    public static <T> T jsonArrayElementToJava(JSONArray jsonArray, int index, Class<T> type, boolean throwForMissingProperty) {
        if (type == Void.class) {
            return null;
        }
        Object jval = JsonObjectUtility.getTyped(jsonArray, index, type);
        return JsonObjectUtility.jsonValueToJava(jval, type, throwForMissingProperty);
    }

    private static <T> T jsonValueToJava(Object jval, Class<T> type, boolean throwForMissingProperty) {
        T o;
        if (jval == null || jval == JSONObject.NULL) {
            return null;
        }
        if (type == String.class) {
            return (T)jval;
        }
        if (type == byte[].class) {
            return (T)new JsonByteArray((String)jval).getBytes();
        }
        if (type == Date.class) {
            return (T)new JsonDate((String)jval).asJavaDate();
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return (T)jval;
        }
        if (type == Long.TYPE || type == Long.class) {
            return (T)jval;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return (T)jval;
        }
        if (jval instanceof JSONArray) {
            JSONArray jarray = (JSONArray)jval;
            int n = jarray.length();
            Object array = Array.newInstance(type.getComponentType(), n);
            int i = 0;
            while (i < n) {
                Array.set(array, i, JsonObjectUtility.jsonArrayElementToJava(jarray, i, type.getComponentType(), throwForMissingProperty));
                ++i;
            }
            return (T)array;
        }
        JSONObject jbean = (JSONObject)jval;
        try {
            o = type.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("type " + String.valueOf(type) + " object " + String.valueOf(jval), e);
        }
        try {
            int n;
            HashSet missingNames = new HashSet();
            String[] nameArray = JsonObjectUtility.getNames(jbean);
            if (nameArray != null) {
                Collections.addAll(missingNames, nameArray);
                String[] stringArray = nameArray;
                n = nameArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    try {
                        Field f = type.getField(key);
                        if (!Modifier.isStatic(f.getModifiers())) {
                            Object val = JsonObjectUtility.jsonObjectPropertyToJava(jbean, key, f.getType(), throwForMissingProperty);
                            f.set(o, val);
                            missingNames.remove(key);
                        }
                    }
                    catch (NoSuchFieldException | NoSuchElementException exception) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            if (!missingNames.isEmpty()) {
                FastBeanInfo beanInfo = new FastBeanInfo(type, Object.class);
                FastPropertyDescriptor[] fastPropertyDescriptorArray = beanInfo.getPropertyDescriptors();
                int n3 = fastPropertyDescriptorArray.length;
                n = 0;
                while (n < n3) {
                    Method m;
                    FastPropertyDescriptor desc = fastPropertyDescriptorArray[n];
                    String key = desc.getName();
                    if (missingNames.contains(key) && (m = desc.getWriteMethod()) != null) {
                        Object val = JsonObjectUtility.jsonObjectPropertyToJava(jbean, key, m.getParameterTypes()[0], throwForMissingProperty);
                        m.invoke(o, val);
                        missingNames.remove(key);
                    }
                    ++n;
                }
            }
            if (throwForMissingProperty && !missingNames.isEmpty()) {
                throw new IllegalArgumentException("properties " + String.valueOf(missingNames) + " do not exist in " + String.valueOf(type));
            }
            return o;
        }
        catch (IllegalAccessException | RuntimeException | InvocationTargetException e) {
            throw new IllegalArgumentException(String.valueOf(jbean) + " to " + String.valueOf(type), e);
        }
    }

    private static Object getTyped(JSONObject jsonObject, String propertyName, Class<?> type) {
        Object jval = jsonObject.opt(propertyName);
        if (jval == null || jval == JSONObject.NULL) {
            return null;
        }
        if (type == byte[].class) {
            return jsonObject.getString(propertyName);
        }
        if (type == Date.class) {
            return jsonObject.getString(propertyName);
        }
        if (jval instanceof JSONArray) {
            return jval;
        }
        if (type == String.class) {
            return jsonObject.getString(propertyName);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return jsonObject.getInt(propertyName);
        }
        if (type == Long.TYPE || type == Long.class) {
            return jsonObject.getLong(propertyName);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return jsonObject.getBoolean(propertyName);
        }
        if (type.getName().startsWith("java.")) {
            throw new IllegalArgumentException("Cannot convert " + String.valueOf(type) + " from json to java object");
        }
        return jsonObject.getJSONObject(propertyName);
    }

    private static Object getTyped(JSONArray jsonArray, int index, Class<?> type) {
        Object jval = jsonArray.opt(index);
        if (jval == null || jval == JSONObject.NULL) {
            return null;
        }
        if (type == byte[].class) {
            return jsonArray.getString(index);
        }
        if (type == Date.class) {
            return jsonArray.getString(index);
        }
        if (jval instanceof JSONArray) {
            return jval;
        }
        if (type == String.class) {
            return jsonArray.getString(index);
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return jsonArray.getInt(index);
        }
        if (type == Long.TYPE || type == Long.class) {
            return jsonArray.getLong(index);
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return jsonArray.getBoolean(index);
        }
        if (type.getName().startsWith("java.")) {
            throw new IllegalArgumentException("Cannot convert " + String.valueOf(type) + " from json to java object");
        }
        return jsonArray.getJSONObject(index);
    }

    public static void filterDefaultValues(JSONObject json) {
        if (json == null) {
            return;
        }
        IDefaultValuesFilterService filterSvc = (IDefaultValuesFilterService)BEANS.get(IDefaultValuesFilterService.class);
        if (filterSvc != null) {
            filterSvc.filter(json);
        }
    }

    public static void filterDefaultValues(JSONObject json, String objectType) {
        if (json == null) {
            return;
        }
        IDefaultValuesFilterService filterSvc = (IDefaultValuesFilterService)BEANS.get(IDefaultValuesFilterService.class);
        if (filterSvc != null) {
            filterSvc.filter(json, objectType);
        }
    }
}

