/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collection;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.config.PlatformConfigProperties;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.PlatformError;
import org.eclipse.scout.rt.platform.resource.MimeType;
import org.eclipse.scout.rt.platform.util.ConnectionErrorDetector;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.concurrent.IRunnable;
import org.eclipse.scout.rt.server.commons.servlet.cache.HttpCacheControl;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;
import org.eclipse.scout.rt.ui.html.HttpSessionHelper;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.eclipse.scout.rt.ui.html.UiSession;
import org.eclipse.scout.rt.ui.html.json.JsonRequest;
import org.eclipse.scout.rt.ui.html.json.JsonRequestHelper;
import org.eclipse.scout.rt.ui.html.json.JsonStartupRequest;
import org.eclipse.scout.rt.ui.html.logging.IUiRunContextDiagnostics;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Order(value=4500.0)
public class JsonMessageRequestHandler
extends AbstractUiServletRequestHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JsonMessageRequestHandler.class);
    private final int m_pollingInterval = ((Long)CONFIG.getPropertyValue(UiHtmlConfigProperties.BackgroundPollingIntervalProperty.class)).intValue();
    private final int m_maxUserIdleTime = ((Long)CONFIG.getPropertyValue(UiHtmlConfigProperties.MaxUserIdleTimeProperty.class)).intValue();
    private final HttpSessionHelper m_httpSessionHelper = (HttpSessionHelper)BEANS.get(HttpSessionHelper.class);
    private final HttpCacheControl m_httpCacheControl = (HttpCacheControl)BEANS.get(HttpCacheControl.class);
    private final JsonRequestHelper m_jsonRequestHelper = (JsonRequestHelper)BEANS.get(JsonRequestHelper.class);

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean handlePost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        block18: {
            pathInfo = req.getPathInfo();
            if (ObjectUtility.notEquals((Object)pathInfo, (Object)"/json")) {
                return false;
            }
            contentType = req.getContentType();
            if (contentType == null || !contentType.contains(MimeType.JSON.getType())) {
                JsonMessageRequestHandler.LOG.info("Request with wrong content type received, ignoring. ContentType: {}, IP:{}", (Object)contentType, (Object)req.getRemoteAddr());
                resp.sendError(415);
                return true;
            }
            startNanos = System.nanoTime();
            if (JsonMessageRequestHandler.LOG.isDebugEnabled()) {
                JsonMessageRequestHandler.LOG.debug("JSON request started");
            }
            uiSession = null;
            jsonRequest = null;
            try {
                block19: {
                    this.m_httpCacheControl.checkAndSetCacheHeaders(req, resp, null);
                    jsonObject = this.m_jsonRequestHelper.readJsonRequest((ServletRequest)req);
                    jsonRequest = new JsonRequest(jsonObject);
                    if (jsonRequest.getRequestType() == JsonRequest.RequestType.PING_REQUEST) {
                        this.handlePingRequest(resp);
                        return true;
                    }
                    if (jsonRequest.getRequestType() != JsonRequest.RequestType.STARTUP_REQUEST) break block19;
                    jsonStartupRequest = new JsonStartupRequest(jsonRequest);
                    if (!this.validateVersion(jsonStartupRequest, resp)) {
                        return true;
                    }
                    uiSession = this.createUiSession(req, resp, jsonStartupRequest);
                    ** GOTO lbl35
                }
                uiSession = UiSession.get(req, jsonRequest);
                if (!this.validateUiSession(uiSession, resp, jsonRequest)) {
                    return true;
                }
                try {
                    if (jsonRequest.getRequestType() != JsonRequest.RequestType.POLL_REQUEST) {
                        uiSession.touch();
                    }
lbl35:
                    // 4 sources

                    uiSession.verifySubject(req);
                    RunContexts.copyCurrent().withThreadLocal(IUiSession.CURRENT, (Object)uiSession).withThreadLocal(JsonRequest.CURRENT, (Object)jsonRequest).withDiagnostics((Collection)BEANS.all(IUiRunContextDiagnostics.class)).run((IRunnable)LambdaMetafactory.metafactory(null, null, null, ()V, lambda$0(jakarta.servlet.http.HttpServletRequest jakarta.servlet.http.HttpServletResponse ), ()V)((JsonMessageRequestHandler)this, (HttpServletRequest)req, (HttpServletResponse)resp), DefaultExceptionTranslator.class);
                }
                catch (Exception | PlatformError e) {
                    if (((ConnectionErrorDetector)BEANS.get(ConnectionErrorDetector.class)).isConnectionError(e)) {
                        JsonMessageRequestHandler.LOG.debug("Connection error detected: exception class={}, message={}.", new Object[]{e.getClass().getSimpleName(), e.getMessage(), e});
                        break block18;
                    }
                    if (jsonRequest == null || uiSession == null || jsonRequest.getRequestType() == JsonRequest.RequestType.STARTUP_REQUEST) {
                        JsonMessageRequestHandler.LOG.error("Error while initializing UI session", e);
                        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createStartupFailedResponse());
                        break block18;
                    }
                    JsonMessageRequestHandler.LOG.error("Unexpected error while processing JSON request", e);
                    this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createUnrecoverableFailureResponse());
                }
            }
            finally {
                if (JsonMessageRequestHandler.LOG.isDebugEnabled()) {
                    JsonMessageRequestHandler.LOG.debug("JSON request completed in {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - startNanos)));
                }
            }
        }
        return true;
    }

    protected void handleJsonRequest(IUiSession uiSession, JsonRequest jsonRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        uiSession.confirmResponseProcessed(jsonRequest.getAckSequenceNo());
        switch (jsonRequest.getRequestType()) {
            case LOG_REQUEST: {
                this.handleLogRequest(httpServletResponse, uiSession, jsonRequest);
                return;
            }
            case CANCEL_REQUEST: {
                this.handleCancelRequest(httpServletResponse, uiSession);
                return;
            }
            case UNLOAD_REQUEST: {
                this.handleUnloadRequest(httpServletResponse, uiSession, jsonRequest);
                return;
            }
            case SYNC_RESPONSE_QUEUE: {
                this.handleSyncResponseQueueRequest(httpServletResponse, uiSession, jsonRequest);
                return;
            }
            case REQUEST: 
            case STARTUP_REQUEST: 
            case POLL_REQUEST: {
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected request type: " + String.valueOf((Object)jsonRequest.getRequestType()));
            }
        }
        if (jsonRequest.getRequestType() == JsonRequest.RequestType.POLL_REQUEST) {
            boolean success = this.handlePollRequest(uiSession, jsonRequest);
            if (!success) {
                return;
            }
            if (!uiSession.uiSessionLock().tryLock()) {
                JSONObject response = uiSession.getAlreadyProcessedResponse(jsonRequest);
                if (response != null) {
                    LOG.info("Request #{} was already processed. Sending back response from history.", (Object)jsonRequest.getSequenceNo());
                } else {
                    LOG.debug("Creating empty response [{}, #{}, #ACK {}]", new Object[]{"CER_HJR", jsonRequest.getSequenceNo(), jsonRequest.getAckSequenceNo()});
                    response = this.m_jsonRequestHelper.createEmptyResponse();
                }
                this.writeJsonResponse((ServletResponse)httpServletResponse, response);
                return;
            }
        } else {
            uiSession.uiSessionLock().lock();
        }
        try {
            if (uiSession.isDisposed()) {
                this.handleUiSessionDisposed(httpServletResponse, uiSession, jsonRequest);
            } else {
                this.handleEvents(httpServletRequest, httpServletResponse, uiSession, jsonRequest);
            }
        }
        finally {
            uiSession.uiSessionLock().unlock();
        }
    }

    protected void handleEvents(HttpServletRequest req, HttpServletResponse resp, IUiSession uiSession, JsonRequest jsonReq) throws IOException {
        JSONObject jsonResp = uiSession.processJsonRequest(req, resp, jsonReq);
        if (jsonResp == null) {
            LOG.debug("Creating empty response [{}, #{}, #ACK {}]", new Object[]{"CER_HE", jsonReq.getSequenceNo(), jsonReq.getAckSequenceNo()});
            jsonResp = this.m_jsonRequestHelper.createEmptyResponse();
        }
        this.writeJsonResponse((ServletResponse)resp, jsonResp);
    }

    protected void handleUiSessionDisposed(HttpServletResponse resp, IUiSession uiSession, JsonRequest jsonReq) throws IOException {
        boolean platformValid;
        boolean bl = platformValid = Platform.get() != null && Platform.get().getState() == IPlatform.State.PlatformStarted;
        if (platformValid && jsonReq.getRequestType() == JsonRequest.RequestType.POLL_REQUEST) {
            this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createSessionTerminatedResponse(uiSession.getLogoutRedirectUrl()));
        } else {
            this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createSessionTimeoutResponse());
        }
    }

    protected void handlePingRequest(HttpServletResponse resp) throws IOException {
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createPingResponse());
    }

    protected void handleLogRequest(HttpServletResponse resp, IUiSession uiSession, JsonRequest jsonRequest) throws IOException {
        Object message = this.truncateLogMessage(jsonRequest.getMessage());
        JSONObject event = jsonRequest.getEvent();
        String level = ((String)ObjectUtility.nvl((Object)jsonRequest.getRequestObject().optString("level"), (Object)"error")).toLowerCase();
        Object header = "JavaScript log message";
        if ("error".equals(level)) {
            header = "JavaScript exception occurred";
        }
        if (event != null) {
            String target = event.getString("target");
            String type = event.getString("type");
            header = (String)header + " while processing event " + type + " for adapter " + String.valueOf(uiSession.getJsonAdapter(target));
        }
        message = (String)header + "\n" + (String)message;
        switch (level) {
            case "trace": {
                LOG.trace((String)message);
                break;
            }
            case "debug": {
                LOG.debug((String)message);
                break;
            }
            case "info": {
                LOG.info((String)message);
                break;
            }
            case "warn": {
                LOG.warn((String)message);
                break;
            }
            default: {
                LOG.error((String)message);
            }
        }
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createEmptyResponse());
    }

    protected String truncateLogMessage(String message) {
        if (message.length() > 10000) {
            return message.substring(0, 9500) + "[---------- " + (message.length() - 10000) + " characters omitted ----------]" + message.substring(message.length() - 500);
        }
        return message;
    }

    protected void handleCancelRequest(HttpServletResponse resp, IUiSession uiSession) throws IOException {
        uiSession.processCancelRequest();
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createEmptyResponse());
    }

    protected boolean handlePollRequest(IUiSession uiSession, JsonRequest jsonRequest) {
        int curIdle = (int)((System.currentTimeMillis() - uiSession.getLastAccessedTime()) / 1000L);
        int maxIdle = this.m_maxUserIdleTime;
        int pollWait = Math.max(Math.min(maxIdle - curIdle, this.m_pollingInterval), 3);
        LOG.debug("Polling begin for {} seconds", (Object)pollWait);
        long startNanos = System.nanoTime();
        try {
            uiSession.waitForBackgroundJobs(jsonRequest, pollWait);
        }
        catch (InterruptedException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Polling INTERRUPTED after {} ms (ignoring response)", (Object)StringUtility.formatNanos((long)(System.nanoTime() - startNanos)));
            }
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Polling end after {} ms", (Object)StringUtility.formatNanos((long)(System.nanoTime() - startNanos)));
        }
        return true;
    }

    protected void handleSessionTimeout(HttpServletResponse resp, JsonRequest jsonReq) throws IOException {
        LOG.info("Request cannot be processed due to UI session timeout [id={}]", (Object)jsonReq.getUiSessionId());
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createSessionTimeoutResponse());
    }

    protected void handleMaxIdeTimeout(HttpServletResponse resp, IUiSession uiSession, int idleSeconds, int maxIdleSeconds) throws IOException {
        LOG.info("Detected idle timeout for UI session {} after {} seconds (maxIdleSeconds={})", new Object[]{uiSession.getUiSessionId(), idleSeconds, maxIdleSeconds});
        uiSession.uiSessionLock().lock();
        try {
            uiSession.dispose();
        }
        finally {
            uiSession.uiSessionLock().unlock();
        }
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createSessionTimeoutResponse());
    }

    protected void handleUnloadRequest(HttpServletResponse resp, IUiSession uiSession, JsonRequest jsonReq) throws IOException {
        LOG.info("Unloading UI session with ID {} (requested by UI)", (Object)jsonReq.getUiSessionId());
        if (uiSession != null) {
            ReentrantLock uiSessionLock = uiSession.uiSessionLock();
            uiSessionLock.lock();
            try {
                uiSession.dispose();
            }
            finally {
                uiSessionLock.unlock();
            }
        }
        this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createEmptyResponse());
    }

    protected void handleSyncResponseQueueRequest(HttpServletResponse resp, IUiSession uiSession, JsonRequest jsonReq) throws IOException {
        LOG.info("Sync response queue for UI session {}", (Object)uiSession.getUiSessionId());
        ReentrantLock uiSessionLock = uiSession.uiSessionLock();
        uiSessionLock.lock();
        try {
            JSONObject response = uiSession.processSyncResponseQueueRequest(jsonReq);
            if (response == null) {
                LOG.debug("Creating empty response [{}, #{}, #ACK {}]", new Object[]{"CER_HSRQR", jsonReq.getSequenceNo(), jsonReq.getAckSequenceNo()});
                response = this.m_jsonRequestHelper.createEmptyResponse();
            }
            this.writeJsonResponse((ServletResponse)resp, response);
        }
        finally {
            uiSessionLock.unlock();
        }
    }

    protected IUiSession createUiSession(HttpServletRequest req, HttpServletResponse resp, JsonStartupRequest jsonStartupReq) {
        HttpSession httpSession = req.getSession();
        ISessionStore sessionStore = this.m_httpSessionHelper.getSessionStore(httpSession);
        long startNanos = System.nanoTime();
        LOG.debug("Creating new UI session....");
        IUiSession uiSession = (IUiSession)BEANS.get(IUiSession.class);
        uiSession.init(req, resp, jsonStartupReq);
        sessionStore.registerUiSession(uiSession);
        LOG.info("Created new UI session with ID {} in {} ms [maxIdleTime={}s, httpSession.maxInactiveInterval={}s]", new Object[]{uiSession.getUiSessionId(), StringUtility.formatNanos((long)(System.nanoTime() - startNanos)), this.m_maxUserIdleTime, req.getSession().getMaxInactiveInterval()});
        return uiSession;
    }

    protected boolean validateUiSession(IUiSession uiSession, HttpServletResponse resp, JsonRequest jsonRequest) throws IOException {
        int maxIdleSeconds;
        if (uiSession == null) {
            this.handleSessionTimeout(resp, jsonRequest);
            return false;
        }
        int idleSeconds = (int)((System.currentTimeMillis() - uiSession.getLastAccessedTime()) / 1000L);
        if (idleSeconds > (maxIdleSeconds = this.m_maxUserIdleTime)) {
            this.handleMaxIdeTimeout(resp, uiSession, idleSeconds, maxIdleSeconds);
            return false;
        }
        return true;
    }

    protected boolean validateVersion(JsonStartupRequest jsonStartupRequest, HttpServletResponse resp) throws IOException {
        String requestVersion = jsonStartupRequest.getVersion();
        String applicationVersion = (String)CONFIG.getPropertyValue(PlatformConfigProperties.ApplicationVersionProperty.class);
        if (requestVersion != null && !requestVersion.equals(applicationVersion)) {
            LOG.info("Requested UI version '{}' does not match the actual version '{}'", (Object)requestVersion, (Object)applicationVersion);
            this.writeJsonResponse((ServletResponse)resp, this.m_jsonRequestHelper.createVersionMismatchResponse());
            return false;
        }
        return true;
    }

    protected void writeJsonResponse(ServletResponse servletResponse, JSONObject jsonObject) throws IOException {
        this.m_jsonRequestHelper.writeResponse(servletResponse, jsonObject);
    }

    private /* synthetic */ void lambda$0(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        this.handleJsonRequest(IUiSession.CURRENT.get(), JsonRequest.CURRENT.get(), httpServletRequest, httpServletResponse);
    }
}

