/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Locale;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.NumberFormatProvider;
import org.eclipse.scout.rt.platform.util.date.DateFormatProvider;
import org.eclipse.scout.rt.ui.html.json.IJsonObject;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLocale
implements IJsonObject {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLocale.class);
    private final Locale m_locale;

    public JsonLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public JSONObject toJson() {
        return this.localeToJson(this.m_locale);
    }

    protected JSONObject decimalFormatSymbolsToJson(DecimalFormatSymbols symbols) {
        JSONObject json = new JSONObject();
        json.put("decimalSeparator", (Object)String.valueOf(symbols.getDecimalSeparator()));
        json.put("groupingSeparator", (Object)String.valueOf(symbols.getGroupingSeparator()));
        json.put("minusSign", (Object)String.valueOf(symbols.getMinusSign()));
        return json;
    }

    protected JSONObject dateFormatSymbolsToJson(DateFormatSymbols symbols) {
        JSONObject json = new JSONObject();
        json.put("months", (Object)new JSONArray((Object)Arrays.copyOf(symbols.getMonths(), 12)));
        json.put("monthsShort", (Object)new JSONArray((Object)Arrays.copyOf(symbols.getShortMonths(), 12)));
        json.put("weekdays", (Object)new JSONArray((Object)Arrays.copyOfRange(symbols.getWeekdays(), 1, 8)));
        json.put("weekdaysShort", (Object)new JSONArray((Object)Arrays.copyOfRange(symbols.getShortWeekdays(), 1, 8)));
        json.put("am", (Object)symbols.getAmPmStrings()[0]);
        json.put("pm", (Object)symbols.getAmPmStrings()[1]);
        return json;
    }

    protected JSONObject localeToJson(Locale locale) {
        JSONObject json = new JSONObject();
        DecimalFormat defaultDecimalFormat = JsonLocale.getDefaultDecimalFormat(locale);
        SimpleDateFormat defaultDateFormat = JsonLocale.getDefaultSimpleDateFormat(locale);
        DateFormatProvider dateFormatProvider = (DateFormatProvider)BEANS.get(DateFormatProvider.class);
        String dateFormatPattern = dateFormatProvider.getDateFormatPattern(1, locale);
        String timeFormatPattern = dateFormatProvider.getDateFormatPattern(2, locale);
        json.put("languageTag", (Object)locale.toLanguageTag());
        json.put("displayLanguage", (Object)locale.getDisplayLanguage(locale));
        json.put("displayCountry", (Object)locale.getDisplayCountry(locale));
        json.put("decimalFormatPatternDefault", (Object)defaultDecimalFormat.toPattern());
        json.put("dateFormatPatternDefault", (Object)dateFormatPattern);
        json.put("timeFormatPatternDefault", (Object)timeFormatPattern);
        json.put("decimalFormatSymbols", (Object)this.decimalFormatSymbolsToJson(defaultDecimalFormat.getDecimalFormatSymbols()));
        json.put("dateFormatSymbols", (Object)this.dateFormatSymbolsToJson(defaultDateFormat.getDateFormatSymbols()));
        return json;
    }

    protected static DecimalFormat getDefaultDecimalFormat(Locale locale) {
        return ((NumberFormatProvider)BEANS.get(NumberFormatProvider.class)).getNumberInstance(locale);
    }

    protected static SimpleDateFormat getDefaultSimpleDateFormat(Locale locale) {
        DateFormat format = ((DateFormatProvider)BEANS.get(DateFormatProvider.class)).getDateInstance(2, locale);
        if (format instanceof SimpleDateFormat) {
            return (SimpleDateFormat)format;
        }
        LOG.info("No locale specific date format available, using default locale");
        return new SimpleDateFormat();
    }

    public static JSONObject toJson(Locale locale) {
        return locale == null ? null : new JsonLocale(locale).toJson();
    }
}

