/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.dataobject.DoList;
import org.eclipse.scout.rt.dataobject.IDataObject;
import org.eclipse.scout.rt.dataobject.IDoEntity;
import org.eclipse.scout.rt.dataobject.IIdSignatureDataObjectMapper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.json.JSONArray;
import org.json.JSONObject;

@Bean
public class JsonDataObjectHelper {
    protected final IIdSignatureDataObjectMapper m_defaultDataObjectMapper = (IIdSignatureDataObjectMapper)BEANS.get(IIdSignatureDataObjectMapper.class);
    protected IIdSignatureDataObjectMapper m_dataObjectMapper = null;

    public IIdSignatureDataObjectMapper getDataObjectMapper() {
        return this.m_dataObjectMapper == null ? this.m_defaultDataObjectMapper : this.m_dataObjectMapper;
    }

    public JsonDataObjectHelper withDataObjectMapper(IIdSignatureDataObjectMapper dataObjectMapper) {
        this.m_dataObjectMapper = dataObjectMapper;
        return this;
    }

    public JSONObject dataObjectToJson(IDoEntity dataObject) {
        if (dataObject == null) {
            return null;
        }
        String str = this.getDataObjectMapper().writeValue((Object)dataObject);
        return new JSONObject(str);
    }

    public JSONArray dataObjectsToJson(List<? extends IDoEntity> dataObjects) {
        if (dataObjects == null) {
            return null;
        }
        String str = this.getDataObjectMapper().writeValue(dataObjects);
        return new JSONArray(str);
    }

    public <T extends IDoEntity> JSONArray dataObjectsToJson(List<T> dataObjects, Function<T, JSONObject> mapper) {
        return this.dataObjectsToJson(dataObjects, mapper, true);
    }

    public <T extends IDoEntity> JSONArray dataObjectsToJson(List<T> dataObjects, Function<T, JSONObject> mapper, boolean skipNulls) {
        if (dataObjects == null) {
            return null;
        }
        return new JSONArray((Collection)dataObjects.stream().map(mapper).filter(skipNulls ? Objects::nonNull : x -> true).collect(Collectors.toList()));
    }

    public <T extends IDataObject> T jsonToDataObject(JSONObject jsonObject, Class<T> type) {
        if (jsonObject == null) {
            return null;
        }
        return (T)((IDataObject)this.getDataObjectMapper().readValue(jsonObject.toString(), type));
    }

    public <T extends IDataObject> List<T> jsonToDataObjects(JSONArray jsonArray, Class<T> type) {
        if (jsonArray == null) {
            return null;
        }
        DoList list = (DoList)this.getDataObjectMapper().readValue(jsonArray.toString(), DoList.class);
        return (List)list.get();
    }
}

