/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.shared.session.ISessionListener;
import org.eclipse.scout.rt.shared.session.SessionEvent;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonPropertyObserver;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.json.JSONObject;

public class JsonClientSession<CLIENT_SESSION extends IClientSession>
extends AbstractJsonPropertyObserver<CLIENT_SESSION> {
    private ISessionListener m_sessionListener;

    public JsonClientSession(CLIENT_SESSION model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Session";
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_sessionListener != null) {
            throw new IllegalStateException();
        }
        this.m_sessionListener = new P_SessionListener();
        ((IClientSession)this.getModel()).addListener(this.m_sessionListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_sessionListener == null) {
            throw new IllegalStateException();
        }
        ((IClientSession)this.getModel()).removeListener(this.m_sessionListener);
        this.m_sessionListener = null;
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        this.attachAdapter(((IClientSession)this.getModel()).getDesktop());
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        json.put("objectType", (Object)this.getObjectType());
        this.putAdapterIdProperty(json, "desktop", ((IClientSession)this.getModel()).getDesktop());
        return json;
    }

    @Override
    protected void initJsonProperties(CLIENT_SESSION model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<CLIENT_SESSION>("sharedVariableMap", (IClientSession)model){

            @Override
            protected Map<String, Object> modelValue() {
                return JsonClientSession.this.getExposedSharedVariables();
            }

            @Override
            public Object prepareValueForToJson(Object value) {
                return MainJsonObjectFactory.get().createJsonObject(value).toJson();
            }
        });
    }

    @Override
    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
        if ("locale".equals(propertyName)) {
            this.getUiSession().sendLocaleChangedEvent((Locale)newValue);
        } else {
            super.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected Map<String, Object> getExposedSharedVariables() {
        Set exposedSharedVariables = ((IClientSession)this.getModel()).getExposedSharedVariables();
        if (exposedSharedVariables.isEmpty()) {
            return Collections.emptyMap();
        }
        return (Map)((IClientSession)this.getModel()).getSharedVariableMap().entrySet().stream().filter(entry -> exposedSharedVariables.contains(entry.getKey())).collect(StreamUtility.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected void handleModelSessionEvent(SessionEvent event) {
        switch (event.getType()) {
            case 105: {
                this.handleModelSessionStopping();
            }
        }
    }

    protected void handleModelSessionStopping() {
        this.getUiSession().logout();
    }

    protected class P_SessionListener
    implements ISessionListener {
        protected P_SessionListener() {
        }

        public void sessionChanged(SessionEvent event) {
            JsonClientSession.this.handleModelSessionEvent(event);
        }
    }
}

