/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.platform.index.AbstractMultiValueIndex;
import org.eclipse.scout.rt.platform.index.AbstractSingleValueIndex;
import org.eclipse.scout.rt.platform.index.IIndex;
import org.eclipse.scout.rt.platform.index.IndexedStore;
import org.eclipse.scout.rt.platform.util.CompositeObject;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonAdapterRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(JsonAdapterRegistry.class);
    private final IndexedStore<IJsonAdapter<?>> m_store = new IndexedStore();
    private final P_IndexById m_idxById = (P_IndexById)this.m_store.registerIndex((IIndex)new P_IndexById());
    private final P_IndexByModelAndParent m_idxByModelAndParent = (P_IndexByModelAndParent)this.m_store.registerIndex((IIndex)new P_IndexByModelAndParent());
    private final P_IndexByParent m_idxByParent = (P_IndexByParent)this.m_store.registerIndex((IIndex)new P_IndexByParent());
    private final P_IndexByModel m_idxByModel = (P_IndexByModel)this.m_store.registerIndex((IIndex)new P_IndexByModel());
    private final ReentrantReadWriteLock.ReadLock m_readLock;
    private final ReentrantReadWriteLock.WriteLock m_writeLock;

    public JsonAdapterRegistry() {
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.m_readLock = lock.readLock();
        this.m_writeLock = lock.writeLock();
    }

    public void add(IJsonAdapter<?> adapter) {
        this.m_writeLock.lock();
        try {
            this.m_store.add(adapter);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public void remove(String adapterId) {
        this.m_writeLock.lock();
        try {
            IJsonAdapter<?> adapter = this.getById(adapterId);
            if (adapter != null) {
                this.m_store.remove(adapter);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    public int size() {
        this.m_readLock.lock();
        try {
            int n = this.m_store.size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public IJsonAdapter<?> getById(String adapterId) {
        this.m_readLock.lock();
        try {
            IJsonAdapter iJsonAdapter = (IJsonAdapter)this.m_idxById.get(adapterId);
            return iJsonAdapter;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public <MODEL, ADAPTER extends IJsonAdapter<? extends MODEL>> ADAPTER getByModelAndParentAdapter(MODEL model, IJsonAdapter<?> parent) {
        this.m_readLock.lock();
        try {
            IJsonAdapter iJsonAdapter = (IJsonAdapter)this.m_idxByModelAndParent.get(this.createModelAndParentAdapterPair(model, parent));
            return (ADAPTER)iJsonAdapter;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public List<IJsonAdapter<?>> getByParentAdapter(IJsonAdapter<?> parentAdapter) {
        this.m_readLock.lock();
        try {
            List list = this.m_idxByParent.get(parentAdapter);
            return list;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public <MODEL> List<IJsonAdapter<MODEL>> getByModel(MODEL model) {
        this.m_readLock.lock();
        try {
            List adaptersRaw = this.m_idxByModel.get(model);
            ArrayList<IJsonAdapter<MODEL>> adapters = new ArrayList<IJsonAdapter<MODEL>>(adaptersRaw.size());
            for (IJsonAdapter adapterRaw : adaptersRaw) {
                adapters.add(adapterRaw);
            }
            ArrayList<IJsonAdapter<MODEL>> arrayList = adapters;
            return arrayList;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    public void disposeAdapters() {
        this.m_writeLock.lock();
        try {
            for (IJsonAdapter adapter : this.m_store.values()) {
                if (adapter.isDisposed()) continue;
                adapter.dispose();
            }
            if (!this.m_store.isEmpty()) {
                LOG.error("Memory leak detected: JsonAdapterRegistry expected to be empty after disposing all adapters [adapterCount={}]", (Object)this.m_store.size());
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    private <MODEL> CompositeObject createModelAndParentAdapterPair(MODEL model, IJsonAdapter<?> parentAdapter) {
        return new CompositeObject(new Object[]{model, parentAdapter});
    }

    private class P_IndexById
    extends AbstractSingleValueIndex<String, IJsonAdapter<?>> {
        private P_IndexById() {
        }

        protected String calculateIndexFor(IJsonAdapter<?> adapter) {
            return adapter.getId();
        }
    }

    private class P_IndexByModel
    extends AbstractMultiValueIndex<Object, IJsonAdapter<?>> {
        private P_IndexByModel() {
        }

        protected Object calculateIndexFor(IJsonAdapter<?> adapter) {
            return adapter.getModel();
        }
    }

    private class P_IndexByModelAndParent
    extends AbstractSingleValueIndex<CompositeObject, IJsonAdapter<?>> {
        private P_IndexByModelAndParent() {
        }

        protected CompositeObject calculateIndexFor(IJsonAdapter<?> adapter) {
            return JsonAdapterRegistry.this.createModelAndParentAdapterPair(adapter.getModel(), adapter.getParent());
        }
    }

    private class P_IndexByParent
    extends AbstractMultiValueIndex<IJsonAdapter<?>, IJsonAdapter<?>> {
        private P_IndexByParent() {
        }

        protected IJsonAdapter<?> calculateIndexFor(IJsonAdapter<?> adapter) {
            return adapter.getParent();
        }
    }
}

