/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.Collection;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.json.JSONArray;

public abstract class JsonAdapterRefProperty<MODEL>
extends JsonProperty<MODEL> {
    private IJsonAdapter<?> m_rootAdapter;

    public JsonAdapterRefProperty(String propertyName, MODEL model, IJsonAdapter rootAdapter) {
        super(propertyName, model);
        this.m_rootAdapter = rootAdapter;
    }

    @Override
    public Object valueToJson() {
        return this.toJsonInternal(this.modelValue());
    }

    @Override
    public Object prepareValueForToJson(Object value) {
        return () -> this.toJsonInternal(value);
    }

    protected Object toJsonInternal(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            return this.elementsToJson((Collection)value);
        }
        return this.elementToJson(value);
    }

    protected JSONArray elementsToJson(Collection elements) {
        JSONArray jsonAdapterIds = new JSONArray();
        for (Object element : elements) {
            Object id = this.elementToJson(element);
            jsonAdapterIds.put(id);
        }
        return jsonAdapterIds;
    }

    protected Object elementToJson(Object element) {
        if (element == null) {
            return null;
        }
        if (element instanceof IWidget) {
            return this.findAdapterId((IWidget)element);
        }
        throw new ProcessingException("Unexpected data type for element " + String.valueOf(element), new Object[0]);
    }

    protected String findAdapterId(IWidget widget) {
        IJsonAdapter<?> adapter = JsonAdapterUtility.findChildAdapter(this.m_rootAdapter, widget);
        if (adapter == null) {
            throw new IllegalStateException("Adapter not found " + String.valueOf(widget));
        }
        return adapter.getId();
    }

    public IJsonAdapter<?> getRootAdapter() {
        return this.m_rootAdapter;
    }
}

