/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.http.HttpServletRequest;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.classid.ITypeWithClassId;
import org.eclipse.scout.rt.platform.exception.ProcessingException;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.json.JSONObject;

@ApplicationScoped
public class InspectorInfo {
    public static final String PROP_CLASS_ID = "classId";
    public static final String PROP_MODEL_CLASS = "modelClass";
    protected static final String UUID_PATTERN = "[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}";
    public static final Pattern CLASS_ID_WITH_UUID_PATTERN = Pattern.compile("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}(?:_[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12})*");
    private static final MessageDigest SHA256 = InspectorInfo.createSha256Digest();

    private static MessageDigest createSha256Digest() {
        try {
            return MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new ProcessingException("Unable to create SHA-256 message digest.", new Object[]{e});
        }
    }

    public <T> void put(JSONObject json, T model, IUiSession uiSession) {
        if (json == null || model == null) {
            return;
        }
        String classId = null;
        if (model instanceof ITypeWithClassId) {
            classId = ((ITypeWithClassId)model).classId();
        }
        if (!StringUtility.isNullOrEmpty(classId)) {
            json.put(PROP_CLASS_ID, (Object)this.prepareClassId(classId));
        }
        if (UrlHints.isInspectorHint((HttpServletRequest)uiSession.currentHttpRequest())) {
            json.put(PROP_MODEL_CLASS, (Object)model.getClass().getName());
        }
    }

    protected String prepareClassId(String classId) {
        if (CLASS_ID_WITH_UUID_PATTERN.matcher(classId).matches()) {
            return classId;
        }
        byte[] hashedId = SHA256.digest(classId.getBytes(StandardCharsets.UTF_8));
        return new BigInteger(1, hashedId).toString(32);
    }
}

