/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.ui.html.json.JsonObjectUtility;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DefaultValuesFilter {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultValuesFilter.class);
    public static final String PROP_DEFAULTS = "defaults";
    public static final String PROP_OBJECT_TYPE_HIERARCHY = "objectTypeHierarchy";
    private final Map<String, Map<String, Object>> m_defaults = new HashMap<String, Map<String, Object>>();
    private final Map<String, List<String>> m_objectTypeHierarchyFlat = new HashMap<String, List<String>>();

    public void importConfiguration(JSONObject defaultValuesConfiguration) {
        if (defaultValuesConfiguration == null) {
            return;
        }
        this.importConfiguration(defaultValuesConfiguration.optJSONObject(PROP_DEFAULTS), defaultValuesConfiguration.optJSONObject(PROP_OBJECT_TYPE_HIERARCHY));
    }

    public void importConfiguration(JSONObject jsonDefaults, JSONObject jsonObjectTypeHierarchy) {
        this.importDefaults(jsonDefaults);
        this.importObjectTypeHierarchy(jsonObjectTypeHierarchy);
    }

    protected void importDefaults(JSONObject jsonDefaults) {
        if (jsonDefaults == null) {
            return;
        }
        Iterator it = jsonDefaults.keys();
        while (it.hasNext()) {
            String type = (String)it.next();
            JSONObject jsonProperties = jsonDefaults.optJSONObject(type);
            Iterator it2 = jsonProperties.keys();
            while (it2.hasNext()) {
                String prop = (String)it2.next();
                Object value = jsonProperties.opt(prop);
                Map propMap = this.m_defaults.computeIfAbsent(type, k -> new HashMap());
                Object oldValue = propMap.get(prop);
                if (value instanceof JSONObject && oldValue instanceof JSONObject) {
                    JsonObjectUtility.mergeProperties((JSONObject)oldValue, (JSONObject)value);
                    continue;
                }
                propMap.put(prop, value);
            }
        }
    }

    protected void importObjectTypeHierarchy(JSONObject jsonObjectTypeHierarchy) {
        this.generateObjectTypeHierarchyRec(jsonObjectTypeHierarchy, null, this.m_objectTypeHierarchyFlat);
        for (String objectType : this.m_defaults.keySet()) {
            if (this.m_objectTypeHierarchyFlat.containsKey(objectType)) continue;
            this.m_objectTypeHierarchyFlat.put(objectType, Collections.singletonList(objectType));
        }
    }

    protected void generateObjectTypeHierarchyRec(JSONObject json, List<String> currentParentObjectTypes, Map<String, List<String>> targetMap) {
        if (json == null) {
            return;
        }
        if (targetMap == null) {
            throw new IllegalArgumentException("Argument 'targetMap' must not be null");
        }
        Iterator it = json.keys();
        while (it.hasNext()) {
            List<String> existingParentObjectTypes;
            String objectType = (String)it.next();
            Object subHierarchy = json.opt(objectType);
            ArrayList<String> newParentObjectTypes = new ArrayList<String>();
            newParentObjectTypes.add(objectType);
            if (currentParentObjectTypes != null) {
                newParentObjectTypes.addAll(currentParentObjectTypes);
            }
            if (subHierarchy instanceof JSONObject && ((JSONObject)subHierarchy).length() > 0) {
                this.generateObjectTypeHierarchyRec((JSONObject)subHierarchy, newParentObjectTypes, targetMap);
            }
            if ((existingParentObjectTypes = targetMap.get(objectType)) != null) {
                throw new IllegalStateException("Object type '" + objectType + "' has ambiguous parent object types: [" + CollectionUtility.format(existingParentObjectTypes) + "] vs. [" + CollectionUtility.format(newParentObjectTypes) + "]");
            }
            targetMap.put(objectType, newParentObjectTypes);
        }
    }

    protected final Map<String, Map<String, Object>> getDefaults() {
        return this.m_defaults;
    }

    protected final Map<String, List<String>> getObjectTypeHierarchyFlat() {
        return this.m_objectTypeHierarchyFlat;
    }

    public void filter(JSONObject json) {
        if (json == null) {
            return;
        }
        this.filter(json, json.optString("objectType", null));
    }

    public void filter(JSONObject json, String objectType) {
        if (json == null || objectType == null) {
            return;
        }
        List<String> objectTypeHierarchy = this.m_objectTypeHierarchyFlat.get(objectType);
        if (objectTypeHierarchy == null) {
            objectType = objectType.replaceAll(Pattern.quote(":") + ".*", "");
            objectTypeHierarchy = this.m_objectTypeHierarchyFlat.get(objectType);
        }
        if (objectTypeHierarchy == null) {
            return;
        }
        FilterState filterState = new FilterState();
        for (String t : objectTypeHierarchy) {
            Iterator it = json.keys();
            while (it.hasNext()) {
                String prop = (String)it.next();
                Object value = json.opt(prop);
                filterState.pushProperty(prop);
                if (!filterState.isCurrentPropertyProcessed() && this.checkPropertyValueEqualToDefaultValue(t, prop, value, filterState)) {
                    it.remove();
                }
                filterState.popProperty(prop);
            }
        }
    }

    protected boolean checkPropertyValueEqualToDefaultValue(String objectType, String propertyName, Object propertyValue, FilterState filterState) {
        Map<String, Object> properties = this.m_defaults.get(objectType);
        if (properties == null) {
            return false;
        }
        if (properties.containsKey(propertyName)) {
            filterState.markCurrentPropertyAsProcessed();
            Object defaultValue = properties.get(propertyName);
            return this.checkValueEqualToDefaultValue(propertyValue, defaultValue, filterState);
        }
        if (properties.containsKey("~" + propertyName)) {
            Object defaultValue = properties.get("~" + propertyName);
            this.checkValueEqualToDefaultValue(propertyValue, defaultValue, filterState);
        }
        return false;
    }

    protected boolean checkValueEqualToDefaultValue(Object value, Object defaultValue, FilterState filterState) {
        if (JSONObject.NULL.equals(value) && JSONObject.NULL.equals(defaultValue)) {
            return true;
        }
        if (JSONObject.NULL.equals(value) || JSONObject.NULL.equals(defaultValue)) {
            return false;
        }
        if (defaultValue instanceof JSONObject) {
            if (value instanceof JSONObject) {
                JSONObject jsonValue = (JSONObject)value;
                JSONObject jsonDefaultValue = (JSONObject)defaultValue;
                return this.filterDefaultObject(jsonValue, jsonDefaultValue, filterState);
            }
            if (value instanceof JSONArray) {
                JSONArray jsonValue = (JSONArray)value;
                JSONObject jsonDefaultValue = (JSONObject)defaultValue;
                this.filterDefaultObject(jsonValue, jsonDefaultValue, filterState);
            }
            return false;
        }
        if (value instanceof JSONArray) {
            value = this.jsonArrayToCollection((JSONArray)value, true);
        }
        if (defaultValue instanceof JSONArray) {
            defaultValue = this.jsonArrayToCollection((JSONArray)defaultValue, false);
        }
        if (value instanceof List && defaultValue instanceof List) {
            return CollectionUtility.equalsCollection((List)((List)value), (List)((List)defaultValue));
        }
        if (value instanceof Collection && defaultValue instanceof Collection) {
            return CollectionUtility.equalsCollection(value, defaultValue);
        }
        try {
            value = TypeCastUtility.castValue(value, defaultValue.getClass());
        }
        catch (RuntimeException e) {
            LOG.warn("Could not cast value '{}' to default value type '{}' for property '{}'", new Object[]{value, defaultValue.getClass().getName(), filterState.getCurrentProperty()});
            return false;
        }
        return ObjectUtility.equals((Object)value, defaultValue);
    }

    protected boolean filterDefaultObject(JSONObject valueObject, JSONObject defaultValueObject, FilterState filterState) {
        boolean sameKeys = CollectionUtility.equalsCollection((Collection)valueObject.keySet(), (Collection)defaultValueObject.keySet());
        Iterator it = valueObject.keys();
        while (it.hasNext()) {
            String prop = (String)it.next();
            filterState.pushProperty(prop);
            if (!filterState.isCurrentPropertyProcessed()) {
                Object subValue = valueObject.opt(prop);
                if (defaultValueObject.has(prop)) {
                    filterState.markCurrentPropertyAsProcessed();
                    subDefaultValue = defaultValueObject.opt(prop);
                    if (this.checkValueEqualToDefaultValue(subValue, subDefaultValue, filterState)) {
                        it.remove();
                    }
                } else if (defaultValueObject.has("~" + prop)) {
                    subDefaultValue = defaultValueObject.opt("~" + prop);
                    this.checkValueEqualToDefaultValue(subValue, subDefaultValue, filterState);
                }
            }
            filterState.popProperty(prop);
        }
        return valueObject.length() == 0 && sameKeys;
    }

    protected void filterDefaultObject(JSONArray valueArray, JSONObject defaultValueObject, FilterState filterState) {
        int i = 0;
        while (i < valueArray.length()) {
            Object value = valueArray.opt(i);
            if (value instanceof JSONObject) {
                JSONObject jsonValue = (JSONObject)value;
                this.filterDefaultObject(jsonValue, defaultValueObject, filterState);
            } else if (value instanceof JSONArray) {
                JSONArray jsonArray = (JSONArray)value;
                this.filterDefaultObject(jsonArray, defaultValueObject, filterState);
            }
            ++i;
        }
    }

    protected Collection<Object> jsonArrayToCollection(JSONArray array, boolean preserveOrder) {
        if (array == null) {
            return null;
        }
        ArrayList<Object> result = preserveOrder ? new ArrayList() : new HashSet();
        int i = 0;
        while (i < array.length()) {
            Object element = array.opt(i);
            if (element instanceof JSONArray) {
                result.add(this.jsonArrayToCollection((JSONArray)element, preserveOrder));
            } else {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    protected class FilterState {
        private final Deque<String> m_propertyStack = new ArrayDeque<String>();
        private final Set<String> m_processedProperties = new HashSet<String>();

        protected FilterState() {
        }

        protected Deque<String> getPropertyStack() {
            return this.m_propertyStack;
        }

        protected Set<String> getCheckedProperties() {
            return this.m_processedProperties;
        }

        public void pushProperty(String propertyName) {
            this.m_propertyStack.push(propertyName);
        }

        public void popProperty(String propertyName) {
            if (ObjectUtility.notEquals((Object)this.m_propertyStack.peek(), (Object)propertyName)) {
                throw new IllegalStateException("'" + propertyName + "' is not the last element in the stack: [" + CollectionUtility.format(this.m_propertyStack) + "]");
            }
            this.m_propertyStack.pop();
        }

        public String getCurrentProperty() {
            if (this.m_propertyStack.size() == 1) {
                return this.m_propertyStack.peek();
            }
            StringBuilder sb = new StringBuilder();
            Iterator<String> it = this.m_propertyStack.descendingIterator();
            while (it.hasNext()) {
                if (sb.length() > 0) {
                    sb.append(".");
                }
                sb.append(it.next());
            }
            return sb.toString();
        }

        public boolean isCurrentPropertyProcessed() {
            return this.m_processedProperties.contains(this.getCurrentProperty());
        }

        public void markCurrentPropertyAsProcessed() {
            this.m_processedProperties.add(this.getCurrentProperty());
        }
    }
}

