/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.client.ui.IWidget;
import org.eclipse.scout.rt.client.ui.ScrollOptions;
import org.eclipse.scout.rt.client.ui.WidgetEvent;
import org.eclipse.scout.rt.client.ui.WidgetListener;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonPropertyObserver;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.MainJsonObjectFactory;
import org.json.JSONObject;

public abstract class AbstractJsonWidget<T extends IWidget>
extends AbstractJsonPropertyObserver<T> {
    protected static final String EVENT_SCROLL_TO_TOP = "scrollToTop";
    protected static final String EVENT_REVEAL = "reveal";
    private WidgetListener m_listener;

    public AbstractJsonWidget(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public String getObjectType() {
        return "Widget";
    }

    @Override
    protected void initJsonProperties(T model) {
        super.initJsonProperties(model);
        this.putJsonProperty(new JsonProperty<T>("cssClass", (IWidget)model){

            @Override
            protected String modelValue() {
                return ((IWidget)this.getModel()).getCssClass();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("enabled", (IWidget)model){

            @Override
            protected Boolean modelValue() {
                return ((IWidget)this.getModel()).isEnabled();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("inheritAccessibility", (IWidget)model){

            @Override
            protected Boolean modelValue() {
                return ((IWidget)this.getModel()).isInheritAccessibility();
            }
        });
        this.putJsonProperty(new JsonProperty<T>("loading", (IWidget)model){

            @Override
            protected Boolean modelValue() {
                return ((IWidget)this.getModel()).isLoading();
            }
        });
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_listener != null) {
            throw new IllegalStateException();
        }
        this.m_listener = new P_WidgetListener();
        ((IWidget)this.getModel()).addWidgetListener(this.m_listener, new Integer[0]);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_listener == null) {
            throw new IllegalStateException();
        }
        ((IWidget)this.getModel()).removeWidgetListener(this.m_listener, new Integer[0]);
        this.m_listener = null;
    }

    protected void handleModelWidgetEvent(WidgetEvent event) {
        if (event.getType() == 100) {
            this.handleModelScrollTopTop(event.getScrollOptions());
        } else if (event.getType() == 400) {
            this.handleModelReveal(event.getScrollOptions());
        }
    }

    protected void handleModelScrollTopTop(ScrollOptions options) {
        this.addActionEvent(EVENT_SCROLL_TO_TOP, this.scrollOptionsToJson(options));
    }

    protected void handleModelReveal(ScrollOptions options) {
        this.addActionEvent(EVENT_REVEAL, this.scrollOptionsToJson(options));
    }

    protected JSONObject scrollOptionsToJson(ScrollOptions options) {
        if (options == null) {
            return null;
        }
        return (JSONObject)MainJsonObjectFactory.get().createJsonObject(options).toJson();
    }

    protected class P_WidgetListener
    implements WidgetListener {
        protected P_WidgetListener() {
        }

        public void widgetChanged(WidgetEvent e) {
            ModelJobs.assertModelThread();
            AbstractJsonWidget.this.handleModelWidgetEvent(e);
        }
    }
}

