/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.client.job.ModelJobs;
import org.eclipse.scout.rt.platform.reflect.IPropertyObserver;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.AbstractJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.IPropertyChangeEventFilterCondition;
import org.eclipse.scout.rt.ui.html.json.JsonProperty;
import org.eclipse.scout.rt.ui.html.json.PropertyChangeEventFilterCondition;
import org.eclipse.scout.rt.ui.html.json.PropertyEventFilter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonPropertyObserver<T extends IPropertyObserver>
extends AbstractJsonAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonPropertyObserver.class);
    private PropertyChangeListener m_propertyChangeListener;
    private final PropertyEventFilter m_propertyEventFilter = new PropertyEventFilter();
    private boolean m_initializingProperties;
    private final Map<String, JsonProperty<?>> m_jsonProperties = new HashMap();
    private final List<JsonProperty<?>> m_customJsonProperties = new ArrayList();

    public AbstractJsonPropertyObserver(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        super(model, uiSession, id, parent);
    }

    @Override
    public void init() {
        this.m_initializingProperties = true;
        this.initJsonProperties((IPropertyObserver)this.getModel());
        this.m_initializingProperties = false;
        super.init();
    }

    protected void initJsonProperties(T model) {
        this.m_customJsonProperties.forEach(prop -> this.putJsonProperty((JsonProperty<?>)prop));
    }

    protected void putJsonProperty(JsonProperty<?> jsonProperty) {
        if (!this.m_initializingProperties) {
            throw new IllegalStateException("Putting properties is only allowed in initJsonProperties.");
        }
        jsonProperty.setParentJsonAdapter(this);
        this.m_jsonProperties.put(jsonProperty.getPropertyName(), jsonProperty);
    }

    protected void removeJsonProperty(String jsonPropertyName) {
        if (!this.m_initializingProperties) {
            throw new IllegalStateException("Putting properties is only allowed in initJsonProperties.");
        }
        this.m_jsonProperties.remove(jsonPropertyName);
    }

    protected JsonProperty<?> getJsonProperty(String name) {
        return this.m_jsonProperties.get(name);
    }

    public final boolean addCustomJsonProperty(JsonProperty<?> property) {
        return this.m_customJsonProperties.add(property);
    }

    public final boolean removeCustomJsonProperty(JsonProperty<?> property) {
        this.removeJsonProperty(property.getPropertyName());
        return this.m_customJsonProperties.remove(property);
    }

    public final List<JsonProperty<?>> getCustomJsonProperties() {
        return Collections.unmodifiableList(this.m_customJsonProperties);
    }

    protected void addPropertyEventFilterCondition(String propertyName, Object value) {
        this.addPropertyEventFilterCondition(new PropertyChangeEventFilterCondition(propertyName, value));
    }

    protected void addPropertyEventFilterCondition(IPropertyChangeEventFilterCondition condition) {
        this.m_propertyEventFilter.addCondition(condition);
    }

    @Override
    protected void attachChildAdapters() {
        super.attachChildAdapters();
        for (JsonProperty<?> prop : this.m_jsonProperties.values()) {
            if (!prop.accept()) continue;
            prop.attachChildAdapters();
        }
    }

    @Override
    protected void attachModel() {
        super.attachModel();
        if (this.m_propertyChangeListener != null) {
            throw new IllegalStateException();
        }
        this.m_propertyChangeListener = new P_PropertyChangeListener();
        ((IPropertyObserver)this.getModel()).addPropertyChangeListener(this.m_propertyChangeListener);
    }

    @Override
    protected void detachModel() {
        super.detachModel();
        if (this.m_propertyChangeListener == null) {
            throw new IllegalStateException();
        }
        ((IPropertyObserver)this.getModel()).removePropertyChangeListener(this.m_propertyChangeListener);
        this.m_propertyChangeListener = null;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = super.toJson();
        for (JsonProperty<?> jsonProperty : this.m_jsonProperties.values()) {
            if (!jsonProperty.accept()) continue;
            this.putProperty(json, jsonProperty.jsonPropertyName(), jsonProperty.valueToJson());
            jsonProperty.setValueSent(true);
        }
        return json;
    }

    protected void handleModelPropertyChange(PropertyChangeEvent event) {
        String propertyName = event.getPropertyName();
        Object oldValue = event.getOldValue();
        Object newValue = event.getNewValue();
        if (this.m_jsonProperties.containsKey(propertyName)) {
            JsonProperty<?> jsonProperty = this.m_jsonProperties.get(propertyName);
            this.handleLazyJsonProperties(jsonProperty);
            newValue = jsonProperty.modelValue();
            jsonProperty.handlePropertyChange(oldValue, newValue);
            if (!jsonProperty.accept()) {
                return;
            }
            PropertyChangeEvent filteredEvent = this.filterPropertyChangeEvent(event);
            if (filteredEvent != null) {
                this.addPropertyChangeEvent(jsonProperty, newValue);
                return;
            }
            if (this.responseAlreadyContainsPropertyChangeEvent(jsonProperty)) {
                this.addPropertyChangeEvent(jsonProperty, newValue);
            }
        } else {
            this.handleModelPropertyChange(propertyName, oldValue, newValue);
        }
    }

    protected boolean responseAlreadyContainsPropertyChangeEvent(JsonProperty<?> jsonProperty) {
        return this.getUiSession().currentJsonResponse().containsPropertyChangeEvent(this.getId(), jsonProperty.getPropertyName());
    }

    protected PropertyChangeEvent filterPropertyChangeEvent(PropertyChangeEvent event) {
        return this.m_propertyEventFilter.filter(event);
    }

    protected void handleLazyJsonProperties(JsonProperty<?> masterProperty) {
        for (JsonProperty<?> lazyProperty : masterProperty.getLazyProperties()) {
            Object modelValue = lazyProperty.modelValue();
            lazyProperty.handlePropertyChange(null, modelValue);
            if (modelValue == null || !lazyProperty.accept() || lazyProperty.isValueSent()) continue;
            this.addPropertyChangeEvent(lazyProperty, modelValue);
        }
    }

    protected void addPropertyChangeEvent(JsonProperty<?> jsonProperty) {
        this.addPropertyChangeEvent(jsonProperty, jsonProperty.modelValue());
    }

    protected void addPropertyChangeEvent(JsonProperty<?> jsonProperty, Object newValue) {
        String propertyName = jsonProperty.jsonPropertyName();
        newValue = jsonProperty.prepareValueForToJson(newValue);
        this.addPropertyChangeEvent(propertyName, newValue);
        jsonProperty.setValueSent(true);
        LOG.debug("Added property change event '{}: {}' for {} with id {}. Model: {}", new Object[]{propertyName, newValue, this.getObjectType(), this.getId(), this.getModel()});
    }

    protected void handleModelPropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void cleanUpEventFilters() {
        this.m_propertyEventFilter.removeAllConditions();
    }

    protected class P_PropertyChangeListener
    implements PropertyChangeListener {
        protected P_PropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            ModelJobs.assertModelThread();
            AbstractJsonPropertyObserver.this.handleModelPropertyChange(event);
        }
    }
}

