/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html.json;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.server.commons.servlet.UrlHints;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.json.IJsonAdapter;
import org.eclipse.scout.rt.ui.html.json.InspectorInfo;
import org.eclipse.scout.rt.ui.html.json.JsonAdapterUtility;
import org.eclipse.scout.rt.ui.html.json.JsonEvent;
import org.eclipse.scout.rt.ui.html.json.JsonEventType;
import org.eclipse.scout.rt.ui.html.json.JsonPropertyChangeEvent;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJsonAdapter<T>
implements IJsonAdapter<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJsonAdapter.class);
    private final IUiSession m_uiSession;
    private final T m_model;
    private final String m_id;
    private boolean m_initialized;
    private boolean m_disposed;
    private final AtomicBoolean m_disposing = new AtomicBoolean();
    private final IJsonAdapter<?> m_parent;

    public AbstractJsonAdapter(T model, IUiSession uiSession, String id, IJsonAdapter<?> parent) {
        if (model == null) {
            throw new IllegalArgumentException("model must not be null");
        }
        this.m_model = model;
        this.m_uiSession = uiSession;
        this.m_id = id;
        this.m_parent = parent;
        this.m_uiSession.registerJsonAdapter(this);
    }

    @Override
    public final String getId() {
        return this.m_id;
    }

    @Override
    public IUiSession getUiSession() {
        return this.m_uiSession;
    }

    @Override
    public IJsonAdapter<?> getParent() {
        return this.m_parent;
    }

    @Override
    public boolean hasAncestor(IJsonAdapter<?> ancestor) {
        IJsonAdapter<?> parent = this.getParent();
        if (parent == null) {
            return false;
        }
        if (parent == ancestor) {
            return true;
        }
        return parent.hasAncestor(ancestor);
    }

    @Override
    public T getModel() {
        return this.m_model;
    }

    protected void attachChildAdapters() {
    }

    protected void disposeChildAdapters() {
        List<IJsonAdapter<?>> childAdapters = this.getUiSession().getJsonChildAdapters(this);
        for (IJsonAdapter<?> childAdapter : childAdapters) {
            if (childAdapter.isDisposed()) continue;
            childAdapter.dispose();
        }
    }

    @Override
    public void init() {
        if (this.m_initialized) {
            throw new IllegalStateException("Adapter already initialized");
        }
        this.attachModel();
        this.attachChildAdapters();
        this.m_initialized = true;
    }

    protected void attachModel() {
    }

    @Override
    public final void dispose() {
        if (!this.m_disposing.compareAndSet(false, true)) {
            return;
        }
        this.detachModel();
        this.disposeChildAdapters();
        this.m_uiSession.unregisterJsonAdapter(this);
        this.m_disposed = true;
    }

    protected void detachModel() {
    }

    @Override
    public boolean isDisposed() {
        return this.m_disposed;
    }

    @Override
    public boolean isInitialized() {
        return this.m_initialized;
    }

    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        this.putProperty(json, "id", this.getId());
        this.putProperty(json, "objectType", this.getObjectTypeVariant());
        ((InspectorInfo)BEANS.get(InspectorInfo.class)).put(json, this.getModel(), this.getUiSession());
        if (this.getParent() == this.getUiSession().getRootJsonAdapter()) {
            this.putProperty(json, "global", true);
        }
        if (UrlHints.isInspectorHint((HttpServletRequest)this.getUiSession().currentHttpRequest())) {
            this.putProperty(json, "owner", this.getParent().getId());
        }
        return json;
    }

    protected String getObjectTypeVariant() {
        return JsonAdapterUtility.getObjectType(this.getObjectType(), this.getModel());
    }

    @Override
    public void handleUiEvent(JsonEvent event) {
        if (!JsonEventType.PROPERTY.matches(event)) {
            throw new IllegalStateException("Event not handled. " + String.valueOf(event));
        }
        this.handleUiPropertyChange(event);
    }

    protected void handleUiPropertyChange(JsonEvent event) {
        JSONObject data = event.getData();
        for (String propertyName : data.keySet()) {
            this.handleUiPropertyChange(propertyName, data);
        }
    }

    protected void handleUiPropertyChange(String propertyName, JSONObject data) {
    }

    public final <A extends IJsonAdapter<M>, M> A attachAdapter(M model) {
        return this.attachAdapter(model, null);
    }

    @Override
    public final <A extends IJsonAdapter<M>, M> A attachAdapter(M model, Predicate<M> filter) {
        if (model == null) {
            return null;
        }
        if (filter != null && !filter.test(model)) {
            return null;
        }
        return this.m_uiSession.getOrCreateJsonAdapter(model, this);
    }

    @Override
    public final <M> List<IJsonAdapter<?>> attachAdapters(Collection<M> models) {
        return this.attachAdapters(models, null);
    }

    @Override
    public final <M> List<IJsonAdapter<?>> attachAdapters(Collection<M> models, Predicate<M> filter) {
        ArrayList adapters = new ArrayList(models.size());
        for (M model : models) {
            Object adapter = this.attachAdapter(model, filter);
            if (adapter == null) continue;
            adapters.add((IJsonAdapter<?>)adapter);
        }
        return adapters;
    }

    @Override
    public final <A extends IJsonAdapter<M>, M> A getAdapter(M model) {
        return this.getAdapter(model, null);
    }

    @Override
    public <A extends IJsonAdapter<M>, M> A getAdapter(M model, Predicate<M> filter) {
        if (model == null) {
            return null;
        }
        if (filter != null && !filter.test(model)) {
            return null;
        }
        return this.m_uiSession.getJsonAdapter(model, this);
    }

    @Override
    public final Collection<IJsonAdapter<?>> getAdapters(Collection<?> models) {
        return this.getAdapters(models, null);
    }

    @Override
    public <M> Collection<IJsonAdapter<?>> getAdapters(Collection<M> models, Predicate<M> filter) {
        ArrayList adapters = new ArrayList(models.size());
        for (M model : models) {
            Object adapter = this.getAdapter(model, filter);
            if (adapter == null) continue;
            adapters.add((IJsonAdapter<?>)adapter);
        }
        return adapters;
    }

    public final <A extends IJsonAdapter<M>, M> A getGlobalAdapter(M model) {
        return this.getGlobalAdapter(model, null);
    }

    public final <A extends IJsonAdapter<M>, M> A getGlobalAdapter(M model, Predicate<M> filter) {
        if (model == null) {
            return null;
        }
        if (filter != null && !filter.test(model)) {
            return null;
        }
        return this.m_uiSession.getJsonAdapter(model, this.getUiSession().getRootJsonAdapter());
    }

    protected final <M> List<IJsonAdapter<?>> attachGlobalAdapters(Collection<M> models) {
        return this.attachGlobalAdapters(models, null);
    }

    protected final <M> List<IJsonAdapter<?>> attachGlobalAdapters(Collection<M> models, Predicate<M> filter) {
        ArrayList adapters = new ArrayList(models.size());
        for (M model : models) {
            Object adapter = this.attachGlobalAdapter(model, filter);
            if (adapter == null) continue;
            adapters.add((IJsonAdapter<?>)adapter);
        }
        return adapters;
    }

    protected final <A extends IJsonAdapter<M>, M> A attachGlobalAdapter(M model) {
        return this.attachGlobalAdapter(model, null);
    }

    protected final <A extends IJsonAdapter<M>, M> A attachGlobalAdapter(M model, Predicate<M> filter) {
        if (model == null) {
            return null;
        }
        if (filter != null && !filter.test(model)) {
            return null;
        }
        return this.m_uiSession.getOrCreateJsonAdapter(model, this.getUiSession().getRootJsonAdapter());
    }

    protected final <M> JSONObject putAdapterIdProperty(JSONObject json, String key, M model) {
        return this.putAdapterIdProperty(json, key, model, null);
    }

    protected final <M> JSONObject putAdapterIdProperty(JSONObject json, String key, M model, Predicate<M> filter) {
        if (model == null) {
            return json;
        }
        if (filter != null && !filter.test(model)) {
            return null;
        }
        return json.put(key, (Object)JsonAdapterUtility.getAdapterIdForModel(this.getUiSession(), model, this));
    }

    protected final <M> JSONObject putAdapterIdsProperty(JSONObject json, String key, Collection<M> models) {
        return this.putAdapterIdsProperty(json, key, models, null);
    }

    protected final <M> JSONObject putAdapterIdsProperty(JSONObject json, String key, Collection<M> models, Predicate<M> filter) {
        return json.put(key, (Object)JsonAdapterUtility.getAdapterIdsForModel(this.getUiSession(), models, this, filter));
    }

    protected final JSONObject putProperty(JSONObject json, String key, Object value) {
        return json.put(key, value);
    }

    protected final JsonEvent addActionEvent(String eventName) {
        return this.addActionEvent(eventName, null);
    }

    protected final JsonEvent addActionEvent(String eventName, JSONObject eventData) {
        return this.addActionEvent(eventName, null, eventData);
    }

    protected final JsonEvent addActionEvent(String eventName, IJsonAdapter<?> referenceAdapter, JSONObject eventData) {
        JsonEvent event;
        if (this.isDisposed()) {
            event = new JsonEvent(this.getId(), eventName, new JSONObject());
            LOG.debug("Adding action event ignored '{}' for disposed {} with id {}. Model: {}", new Object[]{eventName, this.getObjectType(), this.getId(), this.getModel()});
        } else if (referenceAdapter == null) {
            event = this.getUiSession().currentJsonResponse().addActionEvent(this.getId(), eventName, eventData);
            LOG.debug("Added action event '{}' for {} with id {}. Model: {}", new Object[]{eventName, this.getObjectType(), this.getId(), this.getModel()});
        } else {
            event = this.getUiSession().currentJsonResponse().addActionEvent(this.getId(), eventName, referenceAdapter.getId(), eventData);
            LOG.debug("Added action event '{}' for {} with id {} and reference {}. Model: {}", new Object[]{eventName, this.getObjectType(), this.getId(), referenceAdapter.getId(), this.getModel()});
        }
        return event;
    }

    protected final void registerAsBufferedEventsAdapter() {
        this.getUiSession().currentJsonResponse().registerBufferedEventsAdapter(this);
    }

    protected final void unregisterAsBufferedEventsAdapter() {
        this.getUiSession().currentJsonResponse().unregisterBufferedEventsAdapter(this);
    }

    protected final JsonEvent replaceActionEvent(String eventName, JSONObject eventData) {
        return this.getUiSession().currentJsonResponse().replaceActionEvent(this.getId(), eventName, eventData);
    }

    protected JsonEvent addPropertyChangeEvent(String propertyName, Object newValue) {
        if (this.isDisposed()) {
            LOG.debug("Adding property change event ignored '{}' for disposed {} with id {}. Model: {}", new Object[]{propertyName, this.getObjectType(), this.getId(), this.getModel()});
            return new JsonPropertyChangeEvent(this.getId());
        }
        if (newValue instanceof IJsonAdapter) {
            throw new IllegalArgumentException("Cannot pass an adapter instance to a JSON response");
        }
        return this.getUiSession().currentJsonResponse().addPropertyChangeEvent(this.getId(), propertyName, newValue);
    }

    @Override
    public void cleanUpEventFilters() {
    }

    @Override
    public void processBufferedEvents() {
    }

    public String toString() {
        return this.getObjectType() + "[id=" + this.getId() + ", modelClass=" + (this.getModel() == null ? "null" : this.getModel().getClass().getName()) + ", parentId=" + (this.getParent() == null ? "null" : this.getParent().getId()) + "]";
    }
}

