/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.server.commons.servlet.CookieUtility;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class UiThemeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(UiThemeHelper.class);
    private static final String THEME_SESSION_ATTRIBUTE = UiThemeHelper.class.getName() + "#theme";
    private static final String THEME_COOKIE_NAME = "scout.ui.theme";
    private String m_configTheme;
    private boolean m_configThemeRead;

    public static UiThemeHelper get() {
        return (UiThemeHelper)BEANS.get(UiThemeHelper.class);
    }

    public String getConfiguredTheme() {
        if (this.m_configThemeRead) {
            return this.m_configTheme;
        }
        this.m_configTheme = (String)CONFIG.getPropertyValue(UiHtmlConfigProperties.UiThemeProperty.class);
        this.m_configThemeRead = true;
        LOG.info("UI theme configured in config.properties: {}", (Object)this.m_configTheme);
        return this.m_configTheme;
    }

    public String getTheme(HttpServletRequest req) {
        Cookie cookie;
        String theme = null;
        String themeFromSession = null;
        HttpSession session = req.getSession(false);
        if (session != null) {
            theme = themeFromSession = (String)session.getAttribute(THEME_SESSION_ATTRIBUTE);
        }
        if (theme == null && (cookie = CookieUtility.getCookieByName((HttpServletRequest)req, (String)THEME_COOKIE_NAME)) != null) {
            theme = cookie.getValue();
        }
        if (theme == null) {
            theme = this.getConfiguredTheme();
        }
        theme = this.validateTheme(theme);
        if (session != null && ObjectUtility.notEquals((Object)theme, (Object)themeFromSession)) {
            session.setAttribute(THEME_SESSION_ATTRIBUTE, (Object)theme);
        }
        return theme;
    }

    protected String validateTheme(String themeName) {
        return themeName;
    }

    public void storeTheme(HttpServletResponse resp, HttpSession session, String theme) {
        theme = (String)ObjectUtility.nvl((Object)theme, (Object)this.getConfiguredTheme());
        if (resp != null) {
            CookieUtility.addPersistentCookie((HttpServletResponse)resp, (String)THEME_COOKIE_NAME, (String)theme);
        }
        session.setAttribute(THEME_SESSION_ATTRIBUTE, (Object)theme);
    }

    public boolean isDefaultTheme(String theme) {
        return ObjectUtility.equals((Object)theme, (Object)"default");
    }
}

