/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import javax.security.auth.Subject;
import org.eclipse.scout.rt.client.context.ClientRunContexts;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.exception.DefaultExceptionTranslator;
import org.eclipse.scout.rt.server.commons.servlet.AbstractHttpServlet;
import org.eclipse.scout.rt.server.commons.servlet.CookieUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpClientInfo;
import org.eclipse.scout.rt.server.commons.servlet.HttpServletControl;
import org.eclipse.scout.rt.server.commons.servlet.IHttpServletRoundtrip;
import org.eclipse.scout.rt.server.commons.servlet.logging.ServletDiagnosticsProviderFactory;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.ui.html.UiThreadInterruption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UiServlet
extends AbstractHttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(UiServlet.class);
    private static final Set<String> HTTP_METHODS_SUPPORTED_BY_JAKARTA_HTTP_SERVLET = new HashSet<String>(Arrays.asList("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "TRACE"));
    private final HttpServletControl m_httpServletControl = (HttpServletControl)BEANS.get(HttpServletControl.class);
    private final UiThreadInterruption m_uiThreadInterruption = (UiThreadInterruption)BEANS.get(UiThreadInterruption.class);

    protected boolean isHttpMethodSupportedByJakartaHttpServlet(String method) {
        return HTTP_METHODS_SUPPORTED_BY_JAKARTA_HTTP_SERVLET.contains(method);
    }

    protected RunContext createServletRunContext(HttpServletRequest req, HttpServletResponse resp) {
        String cid = req.getHeader("X-Scout-Correlation-Id");
        UserAgent userAgent = HttpClientInfo.get((HttpServletRequest)req).toUserAgents().build();
        return ClientRunContexts.copyCurrent((boolean)true).withSubject(Subject.current()).withThreadLocal(IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_REQUEST, (Object)req).withThreadLocal(IHttpServletRoundtrip.CURRENT_HTTP_SERVLET_RESPONSE, (Object)resp).withDiagnostics((Collection)((ServletDiagnosticsProviderFactory)BEANS.get(ServletDiagnosticsProviderFactory.class)).getProviders(req, resp)).withLocale(this.getPreferredLocale(req)).withCorrelationId(cid != null ? cid : ((CorrelationId)BEANS.get(CorrelationId.class)).newCorrelationId()).withUserAgent(userAgent);
    }

    protected Locale getPreferredLocale(HttpServletRequest req) {
        Cookie cookie = CookieUtility.getCookieByName((HttpServletRequest)req, (String)"scout.preferredLocale");
        if (cookie != null) {
            return Locale.forLanguageTag(cookie.getValue());
        }
        return req.getLocale();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (this.isHttpMethodSupportedByJakartaHttpServlet(req.getMethod())) {
            super.service(req, resp);
        } else {
            this.wrap(req, resp, this::handleHttpMethodsNotSupportedByJakartaHttpServlet);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            this.sendNotFound(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            this.sendNotFound(req, resp);
        }
    }

    protected void doPut(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            this.sendNotFound(req, resp);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            this.sendNotFound(req, resp);
        }
    }

    protected void doHead(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            super.doHead(req, resp);
        }
    }

    protected void doOptions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            super.doOptions(req, resp);
        }
    }

    protected void doTrace(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            super.doTrace(req, resp);
        }
    }

    protected void handleHttpMethodsNotSupportedByJakartaHttpServlet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.handleRequest(req, resp)) {
            resp.sendError(501, "HTTP method not supported");
        }
    }

    protected boolean handleRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.m_uiThreadInterruption.detectAndClear((Object)this, "handleRequest");
        this.m_httpServletControl.doDefaults((HttpServlet)this, req, resp);
        try {
            return (Boolean)this.createServletRunContext(req, resp).call(() -> this.handleRequestInternal(req, resp), DefaultExceptionTranslator.class);
        }
        catch (Exception e) {
            LOG.error("Failed to process HTTP-{} request from UI", (Object)req.getMethod(), (Object)e);
            resp.sendError(500);
            return true;
        }
    }

    /*
     * Exception decompiling
     */
    protected boolean handleRequestInternal(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 6[DOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void sendNotFound(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOG.info("404_NOT_FOUND: {} {}", (Object)req.getMethod(), (Object)req.getPathInfo());
        resp.sendError(404);
    }
}

