/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import jakarta.servlet.MultipartConfigElement;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.eclipse.scout.rt.api.data.ApiExposed;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.AbstractConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveIntegerConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractPositiveLongConfigProperty;
import org.eclipse.scout.rt.platform.config.AbstractStringConfigProperty;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.platform.util.TypeCastUtility;

public final class UiHtmlConfigProperties {
    private UiHtmlConfigProperties() {
    }

    @ApiExposed
    public static class BackgroundPollingIntervalProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.SECONDS.toSeconds(60L);
        }

        public String description() {
            return String.format("The polling request (which waits for a background job to complete) stays open until a background job has completed or the specified number of seconds elapsed.\nThis property must have a value between 3 and the value of property '%s'.\nBy default this property is set to 1 minute.", ((MaxUserIdleTimeProperty)((Object)BEANS.get(MaxUserIdleTimeProperty.class))).getKey());
        }

        public String getKey() {
            return "scout.ui.backgroundPollingMaxWaitTime";
        }
    }

    public static class MaxUploadFileCountProperty
    extends AbstractLongConfigProperty {
        public Long getDefaultValue() {
            return 100L;
        }

        public String description() {
            return "For security reasons, file upload is limited to a maximum number of file that can be processed at once.\nBy default this property is set to 100. A value of -1 means no limit";
        }

        public String getKey() {
            return "scout.ui.maxUploadFileCount";
        }
    }

    public static class MaxUserIdleTimeProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.HOURS.toSeconds(4L);
        }

        public String description() {
            return "If a user is inactive (no user action) for the specified number of seconds, the session is stopped and the user is logged out.\nBy default this property is set to 4 hours.";
        }

        public String getKey() {
            return "scout.ui.maxUserIdleTime";
        }
    }

    public static class SessionStoreHousekeepingDelayProperty
    extends AbstractPositiveIntegerConfigProperty {
        public String getKey() {
            return "scout.ui.sessionstore.housekeepingDelay";
        }

        public String description() {
            return "Number of seconds before the housekeeping job starts after a UI session has been unregistered from the store.\nBy default this property is set to 30 seconds.";
        }

        public Integer getDefaultValue() {
            return 30;
        }
    }

    public static class UiLocalesProperty
    extends AbstractConfigProperty<List<String>, String> {
        public String getKey() {
            return "scout.ui.locales";
        }

        protected List<String> parse(String value) {
            String[] tokens = StringUtility.tokenize((String)value, (char)',');
            return Collections.unmodifiableList(Arrays.asList(tokens));
        }

        public String description() {
            return "Contains a comma separated list of supported locales (e.g. en,en-US,de-CH). To support all locales, use the keyword 'all' instead.\nThis is only relevant if locales.json and texts.json should be sent to the client, which is not the case for remote apps. So this property is only used for JS only apps.\nBy default no locales are supported.";
        }

        public List<String> getDefaultValue() {
            return Collections.emptyList();
        }
    }

    public static class UiModelJobsAwaitTimeoutProperty
    extends AbstractPositiveLongConfigProperty {
        public Long getDefaultValue() {
            return TimeUnit.HOURS.toSeconds(1L);
        }

        public String description() {
            return "The maximal timeout in seconds to wait for model jobs to complete during a UI request. After that timeout the model jobs will be aborted so that the request may return to the client.\nBy default this property is set to 1 hour.";
        }

        public String getKey() {
            return "scout.ui.modelJobTimeout";
        }
    }

    public static class UiServletMultipartConfigProperty
    extends AbstractConfigProperty<MultipartConfigElement, Map<String, String>> {
        private static final String LOCATION = "location";
        private static final String MAX_FILE_SIZE = "maxFileSize";
        private static final String MAX_REQUEST_SIZE = "maxRequestSize";
        private static final String FILE_SIZE_THRESHOLD = "fileSizeThreshold";

        public String getKey() {
            return "scout.ui.servletMultipartConfig";
        }

        public String description() {
            return String.format("Multipart configuration for inbound servlet.\nMap property with the keys as follows:\n- %s: the directory location where files will be stored temporarily (default: temp directory)\n- %s: the maximum size allowed in MB for uploaded files, -1 means unlimited (default: %d MB) \n- %s: the maximum size allowed in MB for multipart/form-data requests, -1 means unlimited (default: %d MB) \n- %s: the size threshold in MB after which files will written to disk (default: %d MB) \n", LOCATION, MAX_FILE_SIZE, this.getDefaultMaxFileSizeMB(), MAX_REQUEST_SIZE, this.getDefaultMaxRequestSizeMB(), FILE_SIZE_THRESHOLD, this.getDefaultFileSizeThresholdMB());
        }

        public Map<String, String> readFromSource(String namespace) {
            return ConfigUtility.getPropertyMap((String)this.getKey(), null, (String)namespace);
        }

        public MultipartConfigElement getDefaultValue() {
            return this.parse(Collections.emptyMap());
        }

        protected String getDefaultLocation() {
            return System.getProperty("java.io.tmpdir");
        }

        protected long getDefaultMaxFileSizeMB() {
            return -1L;
        }

        protected long getDefaultMaxRequestSizeMB() {
            return -1L;
        }

        protected int getDefaultFileSizeThresholdMB() {
            return 20;
        }

        protected MultipartConfigElement parse(Map<String, String> value) {
            HashSet<String> invalidMapKeys = new HashSet<String>(value.keySet());
            Arrays.asList(LOCATION, MAX_FILE_SIZE, MAX_REQUEST_SIZE, FILE_SIZE_THRESHOLD).forEach(invalidMapKeys::remove);
            if (!invalidMapKeys.isEmpty()) {
                throw new PlatformException("Invalid values for map property {}: {}", new Object[]{this.getKey(), invalidMapKeys});
            }
            String location = (String)ObjectUtility.nvl((Object)StringUtility.nullIfEmpty((Object)value.get(LOCATION)), (Object)this.getDefaultLocation());
            long maxFileSize = (Long)ObjectUtility.nvl((Object)((Long)TypeCastUtility.castValue((Object)value.get(MAX_FILE_SIZE), Long.class)), (Object)this.getDefaultMaxFileSizeMB()) * 1024L * 1024L;
            long maxRequestSize = (Long)ObjectUtility.nvl((Object)((Long)TypeCastUtility.castValue((Object)value.get(MAX_REQUEST_SIZE), Long.class)), (Object)this.getDefaultMaxRequestSizeMB()) * 1024L * 1024L;
            int fileSizeThreshold = (Integer)ObjectUtility.nvl((Object)((Integer)TypeCastUtility.castValue((Object)value.get(FILE_SIZE_THRESHOLD), Integer.class)), (Object)this.getDefaultFileSizeThresholdMB()) * 1024 * 1024;
            return new MultipartConfigElement(location, maxFileSize, maxRequestSize, fileSizeThreshold);
        }
    }

    public static class UiThemeProperty
    extends AbstractStringConfigProperty {
        public static final String DEFAULT_THEME = "default";

        public String getKey() {
            return "scout.ui.theme";
        }

        public String description() {
            return "The name of the UI theme which is activated when the application starts.";
        }

        public String getDefaultValue() {
            return DEFAULT_THEME;
        }
    }
}

