/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import jakarta.servlet.http.HttpSession;
import jakarta.servlet.http.HttpSessionBindingEvent;
import jakarta.servlet.http.HttpSessionBindingListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.session.ClientSessionStopHelper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.session.SessionMetricsHelper;
import org.eclipse.scout.rt.ui.html.ISessionStore;
import org.eclipse.scout.rt.ui.html.IUiSession;
import org.eclipse.scout.rt.ui.html.UiHtmlConfigProperties;
import org.eclipse.scout.rt.ui.html.management.SessionMonitorMBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionStore
implements ISessionStore,
HttpSessionBindingListener {
    private static final Logger LOG = LoggerFactory.getLogger(SessionStore.class);
    protected static final String SESSION_TYPE = "http";
    protected final SessionMetricsHelper m_sessionMetrics = (SessionMetricsHelper)BEANS.get(SessionMetricsHelper.class);
    private final HttpSession m_httpSession;
    private final String m_httpSessionId;
    private volatile boolean m_httpSessionValid = true;
    protected final Map<String, IClientSession> m_clientSessionMap = new HashMap<String, IClientSession>();
    protected final Map<String, IUiSession> m_uiSessionMap = new HashMap<String, IUiSession>();
    protected final Map<String, IUiSession> m_preregisteredUiSessionMap = new HashMap<String, IUiSession>();
    protected final Map<IClientSession, Set<IUiSession>> m_uiSessionsByClientSession = new HashMap<IClientSession, Set<IUiSession>>();
    protected final Map<IClientSession, Set<IUiSession>> m_preregisteredUiSessionsByClientSession = new HashMap<IClientSession, Set<IUiSession>>();
    protected final Map<String, IFuture<?>> m_housekeepingFutures = new HashMap();
    protected final ReentrantReadWriteLock.ReadLock m_readLock;
    protected final ReentrantReadWriteLock.WriteLock m_writeLock;

    protected SessionStore(HttpSession httpSession) {
        Assertions.assertNotNull((Object)httpSession);
        this.m_httpSession = httpSession;
        this.m_httpSessionId = httpSession.getId();
        ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
        this.m_readLock = lock.readLock();
        this.m_writeLock = lock.writeLock();
        ((SessionMonitorMBean)BEANS.get(SessionMonitorMBean.class)).weakRegister(httpSession);
        this.m_sessionMetrics.sessionCreated(SESSION_TYPE);
    }

    @Override
    public HttpSession getHttpSession() {
        return this.m_httpSession;
    }

    @Override
    public String getHttpSessionId() {
        return this.m_httpSessionId;
    }

    @Override
    public final boolean isHttpSessionValid() {
        return this.m_httpSessionValid;
    }

    protected final void setHttpSessionInvalid() {
        this.m_httpSessionValid = false;
    }

    @Override
    public Map<String, IClientSession> getClientSessionMap() {
        this.m_readLock.lock();
        try {
            HashMap<String, IClientSession> hashMap = new HashMap<String, IClientSession>(this.m_clientSessionMap);
            return hashMap;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public Map<String, IUiSession> getUiSessionMap() {
        this.m_readLock.lock();
        try {
            HashMap<String, IUiSession> hashMap = new HashMap<String, IUiSession>(this.m_uiSessionMap);
            return hashMap;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public Map<IClientSession, Set<IUiSession>> getUiSessionsByClientSession() {
        this.m_readLock.lock();
        try {
            HashMap<IClientSession, Set<IUiSession>> copy = new HashMap<IClientSession, Set<IUiSession>>();
            for (Map.Entry<IClientSession, Set<IUiSession>> entry : this.m_uiSessionsByClientSession.entrySet()) {
                copy.put(entry.getKey(), entry.getValue() == null ? null : new HashSet(entry.getValue()));
            }
            HashMap<IClientSession, Set<IUiSession>> hashMap = copy;
            return hashMap;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public int countUiSessions() {
        this.m_readLock.lock();
        try {
            int n = this.m_uiSessionMap.size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public int countClientSessions() {
        this.m_readLock.lock();
        try {
            int n = this.m_clientSessionMap.size();
            return n;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public boolean isEmpty() {
        this.m_readLock.lock();
        try {
            boolean bl = this.m_uiSessionMap.isEmpty() && this.m_preregisteredUiSessionMap.isEmpty() && this.m_clientSessionMap.isEmpty() && this.m_uiSessionsByClientSession.isEmpty();
            return bl;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public IUiSession getUiSession(String uiSessionId) {
        if (uiSessionId == null) {
            return null;
        }
        this.m_readLock.lock();
        try {
            IUiSession iUiSession = this.m_uiSessionMap.get(uiSessionId);
            return iUiSession;
        }
        finally {
            this.m_readLock.unlock();
        }
    }

    @Override
    public IClientSession preregisterUiSession(IUiSession uiSession, String clientSessionId) {
        Assertions.assertNotNull((Object)uiSession);
        String uiSessionId = uiSession.getUiSessionId();
        Assertions.assertNotNull((Object)uiSessionId);
        Assertions.assertTrue((boolean)this.m_httpSessionValid, (String)"Preregister UI session with ID {} to an already used http session with ID {} is not supported.", (Object[])new Object[]{uiSessionId, this.m_httpSessionId});
        LOG.debug("Pre-register UI session with ID {}", (Object)uiSessionId);
        this.m_writeLock.lock();
        try {
            IClientSession clientSession;
            Assertions.assertFalse((boolean)this.m_uiSessionMap.containsKey(uiSessionId), (String)"This session store already contains the uiSessionId '{}'", (Object[])new Object[]{uiSessionId});
            this.m_preregisteredUiSessionMap.put(uiSessionId, uiSession);
            if (clientSessionId == null) {
                return null;
            }
            IFuture<?> future = this.m_housekeepingFutures.get(clientSessionId);
            if (future != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Client session with ID {} reserved for use - session housekeeping cancelled!", (Object)clientSessionId);
                }
                future.cancel(false);
                this.m_housekeepingFutures.remove(clientSessionId);
            }
            if ((clientSession = this.m_clientSessionMap.get(clientSessionId)) == null || !clientSession.isActive() || clientSession.isStopping()) {
                return null;
            }
            this.m_preregisteredUiSessionsByClientSession.computeIfAbsent(clientSession, k -> new HashSet()).add(uiSession);
            IClientSession iClientSession = clientSession;
            return iClientSession;
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public void registerUiSession(IUiSession uiSession) {
        Assertions.assertNotNull((Object)uiSession);
        Assertions.assertTrue((boolean)this.m_httpSessionValid, (String)"Register UI session with ID {} to an already used http session with ID {} is not supported.", (Object[])new Object[]{uiSession.getUiSessionId(), this.m_httpSessionId});
        LOG.debug("Register UI session with ID {} in store (clientSessionId={})", (Object)uiSession.getUiSessionId(), (Object)uiSession.getClientSessionId());
        this.m_writeLock.lock();
        try {
            IClientSession clientSession = uiSession.getClientSession();
            this.m_preregisteredUiSessionMap.remove(uiSession.getUiSessionId());
            Set<IUiSession> map = this.m_preregisteredUiSessionsByClientSession.get(clientSession);
            if (map != null) {
                map.remove(uiSession);
                if (map.isEmpty()) {
                    this.m_preregisteredUiSessionsByClientSession.remove(clientSession);
                }
            }
            this.m_uiSessionMap.put(uiSession.getUiSessionId(), uiSession);
            this.m_clientSessionMap.put(clientSession.getId(), clientSession);
            this.m_uiSessionsByClientSession.computeIfAbsent(clientSession, k -> new HashSet()).add(uiSession);
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    @Override
    public void unregisterUiSession(IUiSession uiSession) {
        if (uiSession == null) {
            return;
        }
        LOG.debug("Unregister UI session with ID {} from store (clientSessionId={})", (Object)uiSession.getUiSessionId(), (Object)uiSession.getClientSessionId());
        this.m_writeLock.lock();
        try {
            Set<IUiSession> map;
            this.m_preregisteredUiSessionMap.remove(uiSession.getUiSessionId());
            this.m_uiSessionMap.remove(uiSession.getUiSessionId());
            IClientSession clientSession = uiSession.getClientSession();
            Set<IUiSession> preregisteredMap = this.m_preregisteredUiSessionsByClientSession.get(clientSession);
            if (preregisteredMap != null) {
                preregisteredMap.remove(uiSession);
                if (preregisteredMap.isEmpty()) {
                    this.m_preregisteredUiSessionsByClientSession.remove(clientSession);
                }
            }
            if ((map = this.m_uiSessionsByClientSession.get(clientSession)) != null) {
                map.remove(uiSession);
                if (map.isEmpty()) {
                    this.m_uiSessionsByClientSession.remove(clientSession);
                }
            }
            LOG.debug("{} UI sessions and {} preregistered UI session remaining for client session {}", new Object[]{map == null ? 0 : map.size(), preregisteredMap == null ? 0 : preregisteredMap.size(), clientSession == null ? null : clientSession.getId()});
            if ((map == null || map.isEmpty()) && (preregisteredMap == null || preregisteredMap.isEmpty())) {
                if (uiSession.isPersistent()) {
                    return;
                }
                this.startHousekeepingInsideWriteLock(clientSession);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
    }

    protected void startHousekeepingInsideWriteLock(IClientSession clientSession) {
        if (clientSession == null) {
            return;
        }
        LOG.debug("Session housekeeping: Schedule job for client session with ID {}", (Object)clientSession.getId());
        IFuture future = Jobs.schedule(() -> this.doHousekeepingOutsideWriteLock(clientSession), (JobInput)Jobs.newInput().withName("Performing session housekeeping for client session with ID {}", new Object[]{clientSession.getId()}).withExceptionHandling((ExceptionHandler)BEANS.get(SessionHousekeepingExceptionHandler.class), true).withExecutionTrigger(Jobs.newExecutionTrigger().withStartIn((long)((Integer)CONFIG.getPropertyValue(UiHtmlConfigProperties.SessionStoreHousekeepingDelayProperty.class)).intValue(), TimeUnit.SECONDS)));
        this.m_housekeepingFutures.put(clientSession.getId(), future);
    }

    protected void doHousekeepingOutsideWriteLock(IClientSession clientSession) {
        this.m_writeLock.lock();
        try {
            if (IFuture.CURRENT.get() != null && ((IFuture)IFuture.CURRENT.get()).isCancelled()) {
                return;
            }
            IFuture<?> otherFuture = this.m_housekeepingFutures.remove(clientSession.getId());
            if (otherFuture != null) {
                otherFuture.cancel(false);
            }
            if (!clientSession.isActive() || clientSession.isStopping()) {
                LOG.info("Session housekeeping: Client session {} is {}, removing it from store", (Object)clientSession.getId(), (Object)(!clientSession.isActive() ? "inactive" : "stopping"));
                this.removeClientSessionInsideWriteLock(clientSession);
                return;
            }
            Set<IUiSession> uiSessions = this.m_uiSessionsByClientSession.get(clientSession);
            Set<IUiSession> preregisteredUiSessions = this.m_preregisteredUiSessionsByClientSession.get(clientSession);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Session housekeeping: Client session {} referenced by {} UI sessions and {} UI session types", new Object[]{clientSession.getId(), uiSessions == null ? 0 : uiSessions.size(), preregisteredUiSessions == null ? 0 : preregisteredUiSessions.size()});
            }
            if ((uiSessions == null || uiSessions.isEmpty()) && (preregisteredUiSessions == null || preregisteredUiSessions.isEmpty())) {
                LOG.info("Session housekeeping: Shutting down client session with ID {} because it is not used anymore", (Object)clientSession.getId());
                this.removeClientSessionInsideWriteLock(clientSession);
            }
        }
        finally {
            this.m_writeLock.unlock();
            this.checkHttpSessionOutsideWriteLock();
            ((ClientSessionStopHelper)BEANS.get(ClientSessionStopHelper.class)).scheduleStop(clientSession, true, "session housekeeping");
        }
    }

    protected void removeClientSessionInsideWriteLock(IClientSession clientSession) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Remove client session with ID {} from session store", (Object)clientSession.getId());
        }
        this.m_clientSessionMap.remove(clientSession.getId());
        if (LOG.isDebugEnabled()) {
            HashSet<IClientSession> flatClientSessions = new HashSet<IClientSession>();
            flatClientSessions.addAll(this.m_uiSessionsByClientSession.keySet());
            flatClientSessions.addAll(this.m_preregisteredUiSessionsByClientSession.keySet());
            HashSet<IUiSession> uiSessionsByClientSession = new HashSet<IUiSession>();
            for (Set<IUiSession> s : this.m_uiSessionsByClientSession.values()) {
                uiSessionsByClientSession.addAll(s);
            }
            HashSet<IUiSession> preregisteredUiSessionsByClientSession = new HashSet<IUiSession>();
            for (Set<IUiSession> s : this.m_preregisteredUiSessionsByClientSession.values()) {
                preregisteredUiSessionsByClientSession.addAll(s);
            }
            LOG.debug("Remaining sessions: [clientSessions: {}, clientSessionFlat: {}, uiSessions: {}, uiSessionsByClientSession: {}, preregisteredUiSessions: {}, preregisteredUiSessionsByClientSession: {}]", new Object[]{this.m_clientSessionMap.size(), flatClientSessions.size(), this.m_uiSessionMap.size(), uiSessionsByClientSession.size(), this.m_preregisteredUiSessionMap.size(), preregisteredUiSessionsByClientSession.size()});
        }
    }

    public void valueBound(HttpSessionBindingEvent event) {
        Assertions.assertTrue((boolean)this.m_httpSessionValid, (String)"Binding to new HTTP session {} is not supported (was already bound to {})", (Object[])new Object[]{event.getSession().getId(), this.m_httpSessionId});
    }

    /*
     * Unable to fully structure code
     */
    public void valueUnbound(HttpSessionBindingEvent event) {
        block10: {
            block9: {
                if (!this.m_httpSessionValid) {
                    return;
                }
                this.m_httpSessionValid = false;
                SessionStore.LOG.info("Detected invalidation of HTTP session {}, cleaning up {} client sessions and {} UI sessions", new Object[]{this.m_httpSessionId, this.m_clientSessionMap.size(), this.m_uiSessionMap.size()});
                clientSessionList = new ArrayList<IClientSession>();
                this.m_writeLock.lock();
                try {
                    try {
                        clientSessionList.addAll(this.m_clientSessionMap.values());
                        for (IUiSession uiSession : new ArrayList<IUiSession>(this.m_uiSessionMap.values())) {
                            uiSession.dispose();
                        }
                        break block9;
                    }
                    catch (Throwable t) {
                        SessionStore.LOG.warn("Unable to dispose ui session for http session id {}", (Object)this.m_httpSessionId, (Object)t);
                        this.m_writeLock.unlock();
                        ** for (clientSession : clientSessionList)
                    }
                }
                catch (Throwable var5_12) {
                    this.m_writeLock.unlock();
                    ** for (clientSession : clientSessionList)
                }
lbl-1000:
                // 1 sources

                {
                    this.doHousekeepingOutsideWriteLock(clientSession);
                    continue;
                }
lbl21:
                // 1 sources

                this.m_sessionMetrics.sessionDestroyed("http");
                break block10;
lbl-1000:
                // 1 sources

                {
                    this.doHousekeepingOutsideWriteLock(clientSession);
                    continue;
                }
lbl28:
                // 1 sources

                this.m_sessionMetrics.sessionDestroyed("http");
                throw var5_12;
            }
            this.m_writeLock.unlock();
            for (IClientSession clientSession : clientSessionList) {
                this.doHousekeepingOutsideWriteLock(clientSession);
            }
            this.m_sessionMetrics.sessionDestroyed("http");
        }
    }

    protected void checkHttpSessionOutsideWriteLock() {
        this.m_writeLock.lock();
        try {
            if (!(this.m_clientSessionMap.isEmpty() && this.m_preregisteredUiSessionMap.isEmpty() && this.m_httpSessionValid)) {
                return;
            }
            int uiSessionMapSize = this.m_uiSessionMap.size();
            int uiSessionsByClientSessionSize = this.m_uiSessionsByClientSession.size();
            if (uiSessionMapSize != 0 || uiSessionsByClientSessionSize != 0) {
                LOG.warn("Leak detection - Session store not empty before HTTP session invalidation: [uiSessionMap: {}, uiSessionsByClientSession: {}]", (Object)uiSessionMapSize, (Object)uiSessionsByClientSessionSize);
            }
        }
        finally {
            this.m_writeLock.unlock();
        }
        try {
            this.m_httpSession.getCreationTime();
            LOG.info("Invalidate HTTP session with ID {} because session store contains no more client sessions", (Object)this.m_httpSessionId);
            this.m_httpSession.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public static class SessionHousekeepingExceptionHandler
    extends ExceptionHandler {
        protected void handleInterruptedException(ThreadInterruptedError e) {
            LOG.warn("Session housekeeping failed.", (Throwable)e);
        }
    }
}

