/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.ui.html.UiSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class RequestHistory {
    private static final Logger LOG = LoggerFactory.getLogger(RequestHistory.class);
    private static final int MAX_REQUEST_HISTORY_SIZE = 100;
    private final Object m_mutex = new Object();
    private Long m_lastProcessedRequestSequenceNo = -1L;
    private final SortedSet<Long> m_missingRequestSequenceNos = new TreeSet<Long>();
    private UiSession m_uiSession;

    public UiSession getUiSession() {
        return this.m_uiSession;
    }

    public RequestHistory withUiSession(UiSession uiSession) {
        this.m_uiSession = uiSession;
        return this;
    }

    protected String getUiSessionId() {
        return this.m_uiSession == null ? null : this.m_uiSession.getUiSessionId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRequestProcessed(Long requestSequenceNo) {
        Assertions.assertNotNull((Object)requestSequenceNo);
        Object object = this.m_mutex;
        synchronized (object) {
            if (requestSequenceNo < this.m_lastProcessedRequestSequenceNo) {
                LOG.debug("Cleanup previously missing request sequence number #{}", (Object)requestSequenceNo);
                this.m_missingRequestSequenceNos.remove(requestSequenceNo);
            } else if (requestSequenceNo - this.m_lastProcessedRequestSequenceNo > 100L) {
                LOG.info("Requested sequence number #{} exceeds max. request history size for UI session {}, dropping entire history. Current state of {}", new Object[]{requestSequenceNo, this.getUiSessionId(), this});
                this.m_missingRequestSequenceNos.clear();
                Long missingSequenceNo = requestSequenceNo - 100L;
                while (missingSequenceNo < requestSequenceNo) {
                    LOG.debug("Remember missing request sequence number #{}", (Object)missingSequenceNo);
                    this.m_missingRequestSequenceNos.add(missingSequenceNo);
                    missingSequenceNo = missingSequenceNo + 1L;
                }
                this.m_lastProcessedRequestSequenceNo = requestSequenceNo;
            } else {
                Long missingSequenceNo = this.m_lastProcessedRequestSequenceNo + 1L;
                while (missingSequenceNo < requestSequenceNo) {
                    LOG.debug("Remember missing request sequence number #{}", (Object)missingSequenceNo);
                    this.m_missingRequestSequenceNos.add(missingSequenceNo);
                    missingSequenceNo = missingSequenceNo + 1L;
                }
                while (this.m_missingRequestSequenceNos.size() > 100) {
                    LOG.info("Max. request history size exceeded for UI session {}, dropping oldest request #{}. Current state of {}", new Object[]{this.getUiSessionId(), this.m_missingRequestSequenceNos.first(), this});
                    this.m_missingRequestSequenceNos.remove(this.m_missingRequestSequenceNos.first());
                }
                this.m_lastProcessedRequestSequenceNo = requestSequenceNo;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRequestProcessed(Long requestSequenceNo) {
        Assertions.assertNotNull((Object)requestSequenceNo);
        Object object = this.m_mutex;
        synchronized (object) {
            block4: {
                if (!this.m_missingRequestSequenceNos.contains(requestSequenceNo)) break block4;
                return false;
            }
            return requestSequenceNo <= this.m_lastProcessedRequestSequenceNo;
        }
    }

    public Long getLastProcessedSequenceNo() {
        return this.m_lastProcessedRequestSequenceNo;
    }

    public SortedSet<Long> getMissingRequestSequenceNos() {
        return new TreeSet<Long>(this.m_missingRequestSequenceNos);
    }

    public String toString() {
        return "RequestHistory: lastProcessedRequestSequenceNo=" + String.valueOf(this.m_lastProcessedRequestSequenceNo) + ", missingRequestSequenceNos=[" + CollectionUtility.format(this.m_missingRequestSequenceNos) + "]";
    }
}

