/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.ui.html;

import jakarta.annotation.PostConstruct;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxy;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxyRequestContext;
import org.eclipse.scout.rt.server.commons.servlet.HttpProxyRequestOptions;
import org.eclipse.scout.rt.ui.html.AbstractUiServletRequestHandler;

public abstract class AbstractRestProxyRequestHandler
extends AbstractUiServletRequestHandler {
    private HttpProxy m_proxy;

    public AbstractRestProxyRequestHandler() {
        this.setProxyInternal((HttpProxy)BEANS.get(HttpProxy.class));
    }

    protected void setProxyInternal(HttpProxy proxy) {
        this.m_proxy = proxy;
    }

    protected HttpProxy getProxy() {
        return this.m_proxy;
    }

    @PostConstruct
    protected void initialize() {
        this.getProxy().withRemoteBaseUrl(this.getRemoteBaseUrl());
    }

    protected abstract String getRemoteBaseUrl();

    protected abstract String getLocalContextPathPrefix();

    protected boolean acceptRequest(HttpServletRequest req) {
        return StringUtility.startsWith((String)req.getPathInfo(), (String)this.getLocalContextPathPrefix());
    }

    @Override
    public boolean handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.acceptRequest(req)) {
            return false;
        }
        this.proxy(req, resp);
        return true;
    }

    protected void proxy(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        HttpProxyRequestOptions options = this.createHttpProxyRequestOptions(req, resp);
        this.getProxy().proxy(req, resp, options);
    }

    protected abstract HttpProxyRequestOptions createHttpProxyRequestOptions(HttpServletRequest var1, HttpServletResponse var2);

    protected HttpProxyRequestContext createHttpProxyRequestContext(HttpServletRequest req) {
        return ((HttpProxyRequestContext)BEANS.get(HttpProxyRequestContext.class)).withRequest(req).withLocalContextPathPrefix(this.getLocalContextPathPrefix());
    }
}

