/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.ImmutablePair;
import org.eclipse.scout.rt.platform.util.LazyValue;
import org.eclipse.scout.rt.platform.util.Pair;
import org.eclipse.scout.rt.platform.util.StreamUtility;
import org.eclipse.scout.rt.shared.ui.webresource.AbstractWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.FileListParser;
import org.eclipse.scout.rt.shared.ui.webresource.WebResourceDescriptor;
import org.eclipse.scout.rt.shared.ui.webresource.WebResources;

@ApplicationScoped
public class ScriptResourceIndexes {
    public static final String INDEX_FILE_NAME = "file-list";
    private static final LazyValue<ScriptResourceIndexes> INSTANCE = new LazyValue(ScriptResourceIndexes.class);
    private final AtomicReference<Map<String, Set<String>>> m_devEntryPointToAssets = new AtomicReference();
    private final AtomicReference<Map<String, Set<String>>> m_prodEntryPointToAssets = new AtomicReference();
    private final AtomicReference<Map<String, String>> m_assetNameToMinifiedName = new AtomicReference();

    public static Set<String> getAssetsForEntryPoint(String entryPoint, boolean minified, boolean cacheEnabled) {
        return ((ScriptResourceIndexes)INSTANCE.get()).getAssets(entryPoint, minified, cacheEnabled);
    }

    public static String getMinifiedPath(String path, boolean cacheEnabled) {
        return ((ScriptResourceIndexes)INSTANCE.get()).toMinifiedPath(path, cacheEnabled);
    }

    public Set<String> getAssets(String entryPoint, boolean minified, boolean cacheEnabled) {
        Set<String> assets = this.entryPointToAssetsIndex(minified, cacheEnabled).get(entryPoint);
        if (assets == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(assets);
    }

    public String toMinifiedPath(String path, boolean cacheEnabled) {
        if (INDEX_FILE_NAME.equals(path)) {
            return path;
        }
        String indexValue = this.assetNameToMinifiedNameIndex(cacheEnabled).get(AbstractWebResourceResolver.stripLeadingSlash(path));
        if (indexValue == null) {
            return path;
        }
        return indexValue;
    }

    protected Map<String, Set<String>> entryPointToAssetsIndex(boolean minified, boolean cacheEnabled) {
        AtomicReference<Map<String, Set<String>>> index = minified ? this.m_prodEntryPointToAssets : this.m_devEntryPointToAssets;
        return this.computeIfAbsentOrDevMode(index, cacheEnabled, () -> this.createIndexEntryPointToAssets(minified, cacheEnabled));
    }

    protected Map<String, String> assetNameToMinifiedNameIndex(boolean cacheEnabled) {
        return this.computeIfAbsentOrDevMode(this.m_assetNameToMinifiedName, cacheEnabled, () -> this.createIndexAssetNameToMinifiedName(cacheEnabled));
    }

    protected Map<String, String> createIndexAssetNameToMinifiedName(boolean cacheEnabled) {
        return this.getFileListEntries(true, cacheEnabled).collect(Collectors.toMap(this::getEntryBasePath, FileListParser.FileListEntry::rawLine, StreamUtility.ignoringMerger(), ConcurrentHashMap::new));
    }

    protected String getEntryBasePath(FileListParser.FileListEntry entry) {
        return entry.asset().toString(true, true, false, false, true);
    }

    protected Map<String, Set<String>> createIndexEntryPointToAssets(boolean minified, boolean cacheEnabled) {
        return this.getFileListEntries(minified, cacheEnabled).flatMap(entry -> entry.entryPoints().stream().map(ep -> new ImmutablePair(ep, (Object)entry.rawLine()))).collect(Collectors.groupingBy(Pair::getLeft, ConcurrentHashMap::new, Collectors.mapping(Pair::getRight, Collectors.toSet())));
    }

    public Stream<FileListParser.FileListEntry> getFileListEntries(boolean minified, boolean cacheEnabled) {
        return WebResources.resolveScriptResources(INDEX_FILE_NAME, minified, cacheEnabled, null).stream().map(WebResourceDescriptor::getUrl).flatMap(this::parseFileListEntries);
    }

    protected Stream<FileListParser.FileListEntry> parseFileListEntries(URL url) {
        return ((FileListParser)BEANS.get(FileListParser.class)).parse(url);
    }

    protected <R> R computeIfAbsentOrDevMode(AtomicReference<R> cache, boolean cacheEnabled, Supplier<R> elementSupplier) {
        if (!cacheEnabled) {
            return elementSupplier.get();
        }
        R current = cache.get();
        if (current != null) {
            return current;
        }
        current = elementSupplier.get();
        cache.set(current);
        return current;
    }
}

