/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.shared.ui.webresource.AbstractWebResourceResolver;
import org.eclipse.scout.rt.shared.ui.webresource.IFilesystemWebResourceRootContributor;

public class FilesystemWebResourceResolver
extends AbstractWebResourceResolver {
    private final List<Path> m_roots = new ArrayList<Path>();

    protected FilesystemWebResourceResolver() {
        BEANS.all(IFilesystemWebResourceRootContributor.class).forEach(contributor -> {
            boolean bl = this.m_roots.addAll(contributor.getRoots());
        });
    }

    @Override
    protected Stream<URL> getResourceImpl(String resourcePath) {
        try {
            return FilesystemWebResourceResolver.resolveUrls(this.m_roots, resourcePath);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    protected static Stream<URL> resolveUrls(Path root, String relPath) {
        return FilesystemWebResourceResolver.resolveUrls(Collections.singleton(root), relPath);
    }

    protected static Stream<URL> resolveUrls(Collection<Path> roots, String relPath) {
        if (roots == null || relPath == null) {
            return Stream.empty();
        }
        return roots.stream().map(root -> root.resolve(relPath)).map(FilesystemWebResourceResolver::toUrl).filter(Objects::nonNull);
    }

    protected static URL toUrl(Path path) {
        if (Files.isReadable(path) && Files.isRegularFile(path, new LinkOption[0])) {
            try {
                return path.toUri().toURL();
            }
            catch (MalformedURLException e) {
                throw new PlatformException("Invalid URL for path '{}'.", new Object[]{path, e});
            }
        }
        return null;
    }
}

