/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui.webresource;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import org.eclipse.scout.rt.shared.ui.webresource.IFilesystemWebResourceRootContributor;

public class DefaultFilesystemWebResourceRootContributor
implements IFilesystemWebResourceRootContributor {
    public static final String WEBPACK_CONFIG_JS = "webpack.config.js";

    @Override
    public List<Path> getRoots() {
        Path moduleRoot = DefaultFilesystemWebResourceRootContributor.findModuleRoot();
        if (moduleRoot == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(moduleRoot.resolve("target/dist"));
    }

    protected static Path findModuleRoot() {
        Path resourceRoot;
        String folderName;
        Path workingDir = Paths.get("", new String[0]).toAbsolutePath();
        Path parentDir = workingDir.getParent();
        if (parentDir == null) {
            return null;
        }
        String appModuleName = folderName = workingDir.getFileName().toString();
        if (folderName.endsWith(".dev") || folderName.endsWith("-dev")) {
            appModuleName = folderName.substring(0, folderName.length() - 4);
        }
        if (DefaultFilesystemWebResourceRootContributor.isValidRootModule(resourceRoot = parentDir.resolve(appModuleName))) {
            return resourceRoot;
        }
        if (appModuleName.endsWith(".app") || appModuleName.endsWith("-app")) {
            appModuleName = appModuleName.substring(0, appModuleName.length() - 4);
        }
        if (DefaultFilesystemWebResourceRootContributor.isValidRootModule(resourceRoot = parentDir.resolve(appModuleName))) {
            return resourceRoot;
        }
        return workingDir;
    }

    protected static boolean isValidRootModule(Path module) {
        return Files.isDirectory(module, new LinkOption[0]) && Files.isReadable(module) && Files.exists(module.resolve(WEBPACK_CONFIG_JS), new LinkOption[0]);
    }
}

