/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.config.ConfigUtility;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiEngineType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.IUiSystem;
import org.eclipse.scout.rt.shared.ui.IUserAgentParser;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiEngineType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UiSystem;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAgents {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgents.class);
    private IUiLayer m_uiLayer = UiLayer.UNKNOWN;
    private IUiDeviceType m_uiDeviceType = UiDeviceType.UNKNOWN;
    private IUiEngineType m_uiEngineType = UiEngineType.UNKNOWN;
    private IUiSystem m_uiSystem = UiSystem.UNKNOWN;
    private String m_uiDeviceId = "n/a";
    private boolean m_touch = false;
    private boolean m_standalone = false;

    private UserAgents() {
    }

    public UserAgents withUiDeviceType(IUiDeviceType uiDeviceType) {
        this.m_uiDeviceType = uiDeviceType;
        return this;
    }

    public UserAgents withUiEngineType(IUiEngineType uiEngineType) {
        this.m_uiEngineType = uiEngineType;
        return this;
    }

    public UserAgents withUiSystem(IUiSystem uiSystem) {
        this.m_uiSystem = uiSystem;
        return this;
    }

    public UserAgents withUiLayer(IUiLayer uiLayer) {
        this.m_uiLayer = uiLayer;
        return this;
    }

    public UserAgents withDeviceId(String uiDeviceId) {
        this.m_uiDeviceId = uiDeviceId;
        return this;
    }

    public UserAgents withDefaultDeviceId() {
        return this.withDeviceId(ConfigUtility.getProperty((String)"os.name"));
    }

    public UserAgents withTouch(boolean touch) {
        this.m_touch = touch;
        return this;
    }

    public UserAgents withStandalone(boolean standalone) {
        this.m_standalone = standalone;
        return this;
    }

    public static UserAgents create() {
        return new UserAgents();
    }

    public static UserAgents create(UserAgent other) {
        return new UserAgents().withUiDeviceType(other.getUiDeviceType()).withUiEngineType(other.getUiEngineType()).withUiLayer(other.getUiLayer()).withUiSystem(other.getUiSystem()).withDeviceId(other.getUiDeviceId()).withTouch(other.isTouch()).withStandalone(other.isStandalone());
    }

    public UserAgent build() {
        return new UserAgent(this.m_uiLayer, this.m_uiDeviceType, this.m_uiEngineType, this.m_uiSystem, this.m_uiDeviceId, this.m_touch, this.m_standalone);
    }

    public static UserAgent createDefault() {
        return UserAgents.create().withDefaultDeviceId().build();
    }

    public static UserAgent createByIdentifier(IUserAgentParser parser, String userAgent) {
        try {
            return parser.parseIdentifier(userAgent);
        }
        catch (RuntimeException e) {
            LOG.error("UserAgentIdentifier could not be parsed. Exception occurred while parsing. UserAgent: {}", (Object)userAgent, (Object)e);
            return UserAgents.createDefault();
        }
    }

    public static UserAgent createByIdentifier(String userAgent) {
        return UserAgents.createByIdentifier((IUserAgentParser)BEANS.get(IUserAgentParser.class), userAgent);
    }
}

