/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserAgentUtility {
    private static final Logger LOG = LoggerFactory.getLogger(UserAgentUtility.class);

    private UserAgentUtility() {
    }

    public static boolean isMobileDevice() {
        return UiDeviceType.MOBILE.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isTabletDevice() {
        return UiDeviceType.TABLET.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isDesktopDevice() {
        return UiDeviceType.DESKTOP.equals(UserAgentUtility.getCurrentUiDeviceType());
    }

    public static boolean isTouchDevice() {
        return UserAgentUtility.getCurrentUserAgent().isTouch();
    }

    public static IUiDeviceType getCurrentUiDeviceType() {
        return UserAgentUtility.getCurrentUserAgent().getUiDeviceType();
    }

    public static IUiLayer getCurrentUiLayer() {
        return UserAgentUtility.getCurrentUserAgent().getUiLayer();
    }

    public static UserAgent getCurrentUserAgent() {
        UserAgent userAgent = UserAgent.CURRENT.get();
        if (userAgent != null) {
            return userAgent;
        }
        LOG.info("No UserAgent in calling context found; using default UserAgent");
        return UserAgents.createDefault();
    }
}

