/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import java.io.Serializable;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.eclipse.scout.rt.shared.ui.IUiDeviceType;
import org.eclipse.scout.rt.shared.ui.IUiEngineType;
import org.eclipse.scout.rt.shared.ui.IUiLayer;
import org.eclipse.scout.rt.shared.ui.IUiSystem;
import org.eclipse.scout.rt.shared.ui.IUserAgentParser;

public final class UserAgent
implements Serializable {
    public static final ThreadLocal<UserAgent> CURRENT = new ThreadLocal();
    private static final long serialVersionUID = 6194949468393137650L;
    private final IUiLayer m_uiLayer;
    private final IUiDeviceType m_uiDeviceType;
    private final IUiEngineType m_uiEngineType;
    private final IUiSystem m_uiSystem;
    private final String m_uiDeviceId;
    private final boolean m_touch;
    private final boolean m_standalone;

    UserAgent(IUiLayer uiLayer, IUiDeviceType uiDeviceType, IUiEngineType uiEngineType, IUiSystem uiSystem, String uiDeviceId, boolean touch, boolean standalone) {
        this.m_uiLayer = (IUiLayer)Assertions.assertNotNull((Object)uiLayer, (String)"UI Layer must not be null", (Object[])new Object[0]);
        this.m_uiDeviceType = (IUiDeviceType)Assertions.assertNotNull((Object)uiDeviceType, (String)"UI device type must not be null", (Object[])new Object[0]);
        this.m_uiDeviceId = (String)Assertions.assertNotNull((Object)uiDeviceId, (String)"UI device id must not be null", (Object[])new Object[0]);
        this.m_uiEngineType = (IUiEngineType)Assertions.assertNotNull((Object)uiEngineType, (String)"UI engineType must not be null", (Object[])new Object[0]);
        this.m_uiSystem = (IUiSystem)Assertions.assertNotNull((Object)uiSystem, (String)"UI system must not be null", (Object[])new Object[0]);
        this.m_touch = touch;
        this.m_standalone = standalone;
    }

    public IUiDeviceType getUiDeviceType() {
        return this.m_uiDeviceType;
    }

    public IUiLayer getUiLayer() {
        return this.m_uiLayer;
    }

    public IUiEngineType getUiEngineType() {
        return this.m_uiEngineType;
    }

    public String getUiDeviceId() {
        return this.m_uiDeviceId;
    }

    public IUiSystem getUiSystem() {
        return this.m_uiSystem;
    }

    public boolean isTouch() {
        return this.m_touch;
    }

    public boolean isStandalone() {
        return this.m_standalone;
    }

    public String toString() {
        return this.createIdentifier();
    }

    public String createIdentifier() {
        return this.createIdentifier((IUserAgentParser)BEANS.get(IUserAgentParser.class));
    }

    public String createIdentifier(IUserAgentParser parser) {
        return parser.createIdentifier(this);
    }

    public static void set(UserAgent userAgent) {
        if (userAgent == null) {
            CURRENT.remove();
        } else {
            CURRENT.set(userAgent);
        }
    }

    public static UserAgent get() {
        return CURRENT.get();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_touch ? 1231 : 1237);
        result = 31 * result + (this.m_uiDeviceId == null ? 0 : this.m_uiDeviceId.hashCode());
        result = 31 * result + (this.m_uiDeviceType == null ? 0 : this.m_uiDeviceType.hashCode());
        result = 31 * result + (this.m_uiEngineType == null ? 0 : this.m_uiEngineType.hashCode());
        result = 31 * result + (this.m_uiLayer == null ? 0 : this.m_uiLayer.hashCode());
        result = 31 * result + (this.m_uiSystem == null ? 0 : this.m_uiSystem.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserAgent other = (UserAgent)obj;
        if (this.m_touch != other.m_touch) {
            return false;
        }
        if (this.m_uiDeviceId == null ? other.m_uiDeviceId != null : !this.m_uiDeviceId.equals(other.m_uiDeviceId)) {
            return false;
        }
        if (this.m_uiDeviceType == null ? other.m_uiDeviceType != null : !this.m_uiDeviceType.equals(other.m_uiDeviceType)) {
            return false;
        }
        if (this.m_uiEngineType == null ? other.m_uiEngineType != null : !this.m_uiEngineType.equals(other.m_uiEngineType)) {
            return false;
        }
        if (this.m_uiLayer == null ? other.m_uiLayer != null : !this.m_uiLayer.equals(other.m_uiLayer)) {
            return false;
        }
        return !(this.m_uiSystem == null ? other.m_uiSystem != null : !this.m_uiSystem.equals(other.m_uiSystem));
    }
}

