/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.ui;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.ui.IUserAgentParser;
import org.eclipse.scout.rt.shared.ui.UiDeviceType;
import org.eclipse.scout.rt.shared.ui.UiEngineType;
import org.eclipse.scout.rt.shared.ui.UiLayer;
import org.eclipse.scout.rt.shared.ui.UiSystem;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultUserAgentParser
implements IUserAgentParser {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultUserAgentParser.class);
    public static final String DELIMITER = "|";

    @Override
    public UserAgent parseIdentifier(String userAgent) {
        String[] tokens = StringUtility.tokenize((String)userAgent, (char)DELIMITER.charAt(0));
        if (tokens.length != 5) {
            throw new PlatformException("Invalid number of tokens", new Object[0]);
        }
        try {
            return UserAgents.create().withUiLayer(UiLayer.createByIdentifier(tokens[0])).withUiDeviceType(UiDeviceType.createByIdentifier(tokens[1])).withUiEngineType(UiEngineType.createByIdentifier(tokens[2])).withUiSystem(UiSystem.createByIdentifier(tokens[3])).withDeviceId(tokens[4]).build();
        }
        catch (IllegalArgumentException e) {
            throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("UserAgent", (Object)userAgent, new Object[0]);
        }
    }

    @Override
    public String createIdentifier(UserAgent userAgent) {
        String uiDeviceId = userAgent.getUiDeviceId();
        if (uiDeviceId.contains(DELIMITER)) {
            uiDeviceId = uiDeviceId.replaceAll("\\|", "_");
            LOG.warn("Character which is used as delimiter has been found in uiDeviceId. Replaced with '_'. Old uiDeviceId: {}. New uiDeviceId: {}", (Object)userAgent.getUiDeviceId(), (Object)uiDeviceId);
        }
        return StringUtility.concatenateTokens((String[])new String[]{userAgent.getUiLayer().stringValue(), DELIMITER, userAgent.getUiDeviceType().stringValue(), DELIMITER, userAgent.getUiEngineType().stringValue(), DELIMITER, userAgent.getUiSystem().stringValue(), DELIMITER, uiDeviceId});
    }
}

