/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.session;

import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.util.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class SessionMetricsHelper {
    private static final Logger LOG = LoggerFactory.getLogger(SessionMetricsHelper.class);
    protected final Map<String, SessionMetrics> m_metrics = new ConcurrentHashMap<String, SessionMetrics>();

    public void sessionCreated(String type) {
        Assertions.assertNotNullOrEmpty((String)type);
        this.m_metrics.computeIfAbsent(type, this::initMetrics).sessionCreated();
    }

    public void sessionDestroyed(String type) {
        Assertions.assertNotNullOrEmpty((String)type);
        this.m_metrics.computeIfAbsent(type, this::initMetrics).sessionDestroyed();
    }

    protected SessionMetrics initMetrics(String type) {
        LOG.info("Init session metrics of type '{}'", (Object)type);
        Meter meter = GlobalOpenTelemetry.get().getMeter(this.getClass().getName());
        return new SessionMetrics(meter, type);
    }

    protected static class SessionMetrics {
        protected static final AttributeKey<String> TYPE = AttributeKey.stringKey((String)"type");
        protected final Attributes m_defaultAttributes;
        protected final LongUpDownCounter m_activeSessions;
        protected final LongCounter m_createdSessions;

        public SessionMetrics(Meter meter, String type) {
            this.m_activeSessions = meter.upDownCounterBuilder("scout.sessions.active").setDescription("The number of active sessions.").setUnit("{session}").build();
            this.m_createdSessions = meter.counterBuilder("scout.sessions.created").setDescription("The number of sessions that has been created since server start.").setUnit("{session}").build();
            this.m_defaultAttributes = Attributes.of(TYPE, (Object)type);
        }

        public void sessionCreated() {
            this.m_activeSessions.add(1L, this.m_defaultAttributes);
            this.m_createdSessions.add(1L, this.m_defaultAttributes);
        }

        public void sessionDestroyed() {
            this.m_activeSessions.add(-1L, this.m_defaultAttributes);
        }
    }
}

