/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpContent;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.Scope;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.CorrelationId;
import org.eclipse.scout.rt.platform.context.RunContext;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.job.IFuture;
import org.eclipse.scout.rt.platform.job.JobInput;
import org.eclipse.scout.rt.platform.job.Jobs;
import org.eclipse.scout.rt.platform.util.UriUtility;
import org.eclipse.scout.rt.platform.util.concurrent.FutureCancelledError;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.http.IHttpTransportManager;
import org.eclipse.scout.rt.shared.opentelemetry.HttpServiceTunnelInstrumenterFactory;
import org.eclipse.scout.rt.shared.servicetunnel.AbstractServiceTunnel;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnelContentHandler;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.servicetunnel.http.ByteArrayContentEx;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthToken;
import org.eclipse.scout.rt.shared.servicetunnel.http.DefaultAuthTokenSigner;
import org.eclipse.scout.rt.shared.servicetunnel.http.HttpServiceTunnelTransportManager;
import org.eclipse.scout.rt.shared.servicetunnel.http.RemoteServiceInvocationCallable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpServiceTunnel
extends AbstractServiceTunnel {
    private static final Logger LOG = LoggerFactory.getLogger(HttpServiceTunnel.class);
    public static final String TOKEN_AUTH_HTTP_HEADER = "X-ScoutAccessToken";
    public static final String ID_SIGNATURE_HTTP_HEADER = "X-ScoutIdSignature";
    private IServiceTunnelContentHandler m_contentHandler;
    private final URL m_serverUrl;
    private final GenericUrl m_genericUrl;
    private final boolean m_active;
    private final Instrumenter<ServiceTunnelRequest, Void> m_instrumenter;

    public HttpServiceTunnel() {
        this(HttpServiceTunnel.getConfiguredServerUrl());
    }

    public HttpServiceTunnel(URL url) {
        this.m_serverUrl = url;
        this.m_genericUrl = url != null ? new GenericUrl(url) : null;
        this.m_active = url != null;
        this.m_instrumenter = ((HttpServiceTunnelInstrumenterFactory)BEANS.get(HttpServiceTunnelInstrumenterFactory.class)).createInstrumenter();
    }

    protected static URL getConfiguredServerUrl() {
        String url = (String)((SharedConfigProperties.ServiceTunnelTargetUrlProperty)((Object)BEANS.get(SharedConfigProperties.ServiceTunnelTargetUrlProperty.class))).getValue();
        try {
            return UriUtility.toUrl((String)url);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("targetUrl: " + url, e);
        }
    }

    @Override
    public boolean isActive() {
        return this.m_active;
    }

    public GenericUrl getGenericUrl() {
        return this.m_genericUrl;
    }

    public URL getServerUrl() {
        return this.m_serverUrl;
    }

    protected HttpResponse executeRequestInternal(ServiceTunnelRequest call, byte[] callData) throws IOException {
        if (!"http".equalsIgnoreCase(this.getServerUrl().getProtocol()) && !"https".equalsIgnoreCase(this.getServerUrl().getProtocol())) {
            throw new IOException("URL '" + this.getServerUrl().toString() + "' is not supported by this tunnel ('" + this.getClass().getName() + "').");
        }
        if (!this.isActive()) {
            String key = ((SharedConfigProperties.ServiceTunnelTargetUrlProperty)((Object)BEANS.get(SharedConfigProperties.ServiceTunnelTargetUrlProperty.class))).getKey();
            throw new IllegalArgumentException("No target URL configured. Please specify a target URL in the config.properties using property '" + key + "'.");
        }
        HttpRequestFactory requestFactory = this.getHttpTransportManager().getHttpRequestFactory();
        HttpRequest request = requestFactory.buildPostRequest(this.getGenericUrl(), (HttpContent)new ByteArrayContentEx(null, callData, false));
        HttpHeaders headers = request.getHeaders();
        headers.setCacheControl("no-cache");
        headers.setContentType(this.getContentHandler().getContentType());
        headers.put("Pragma", (Object)"no-cache");
        this.addCustomHeaders(request, call, callData);
        return request.execute();
    }

    protected HttpResponse executeRequest(ServiceTunnelRequest call, byte[] callData) throws IOException {
        HttpResponse response;
        Context parentContext = Context.current();
        if (!this.m_instrumenter.shouldStart(parentContext, (Object)call)) {
            return this.executeRequestInternal(call, callData);
        }
        Context context = this.m_instrumenter.start(parentContext, (Object)call);
        try {
            Throwable throwable = null;
            Object var7_8 = null;
            try (Scope ignored = context.makeCurrent();){
                response = this.executeRequestInternal(call, callData);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Throwable t) {
            this.m_instrumenter.end(context, (Object)call, null, t);
            throw t;
        }
        this.m_instrumenter.end(context, (Object)call, null, null);
        return response;
    }

    protected IHttpTransportManager getHttpTransportManager() {
        return (IHttpTransportManager)BEANS.get(HttpServiceTunnelTransportManager.class);
    }

    protected void addCustomHeaders(HttpRequest httpRequest, ServiceTunnelRequest call, byte[] callData) throws IOException {
        this.addSignatureHeader(httpRequest, callData);
        this.addCorrelationId(httpRequest);
        this.addOpenTelemetryContextHeader(httpRequest);
        this.addIdSignatureHeader(httpRequest);
    }

    protected void addSignatureHeader(HttpRequest httpRequest, byte[] callData) throws IOException {
        try {
            DefaultAuthToken token = ((DefaultAuthTokenSigner)BEANS.get(DefaultAuthTokenSigner.class)).createDefaultSignedToken(DefaultAuthToken.class);
            if (token != null) {
                httpRequest.getHeaders().put(TOKEN_AUTH_HTTP_HEADER, (Object)token.toString());
            }
        }
        catch (RuntimeException e) {
            throw new IOException(e);
        }
    }

    protected void addCorrelationId(HttpRequest httpRequest) {
        String cid = (String)CorrelationId.CURRENT.get();
        if (cid != null) {
            httpRequest.getHeaders().put("X-Scout-Correlation-Id", (Object)cid);
        }
    }

    protected void addOpenTelemetryContextHeader(HttpRequest httpRequest) {
        TextMapSetter setter = (carrier, key, value) -> {
            if (carrier != null) {
                carrier.getHeaders().set(key, (Object)value);
            }
        };
        GlobalOpenTelemetry.get().getPropagators().getTextMapPropagator().inject(Context.current(), (Object)httpRequest, setter);
    }

    protected void addIdSignatureHeader(HttpRequest httpRequest) {
        if (Optional.ofNullable((RunContext)RunContext.CURRENT.get()).map(rc -> (Boolean)rc.getPropertyOrDefault((Object)"ServiceTunnelOptions.idSignature", (Object)false)).orElse(false).booleanValue()) {
            httpRequest.getHeaders().put(ID_SIGNATURE_HTTP_HEADER, (Object)Boolean.TRUE.toString());
        }
    }

    public IServiceTunnelContentHandler getContentHandler() {
        return this.m_contentHandler;
    }

    public void setContentHandler(IServiceTunnelContentHandler e) {
        this.m_contentHandler = e;
    }

    public Object invokeService(Class serviceInterfaceClass, Method operation, Object[] callerArgs) {
        if (this.m_contentHandler == null) {
            this.m_contentHandler = (IServiceTunnelContentHandler)BEANS.get(IServiceTunnelContentHandler.class);
            this.m_contentHandler.initialize();
        }
        return super.invokeService(serviceInterfaceClass, operation, callerArgs);
    }

    protected RemoteServiceInvocationCallable createRemoteServiceInvocationCallable(ServiceTunnelRequest serviceRequest) {
        return new RemoteServiceInvocationCallable(this, serviceRequest);
    }

    @Override
    protected ServiceTunnelResponse tunnel(ServiceTunnelRequest serviceRequest) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("requestSequence {} {}.{}", new Object[]{serviceRequest.getRequestSequence(), serviceRequest.getServiceInterfaceClassName(), serviceRequest.getOperation()});
        }
        long requestSequence = serviceRequest.getRequestSequence();
        RemoteServiceInvocationCallable remoteInvocationCallable = this.createRemoteServiceInvocationCallable(serviceRequest);
        IFuture future = Jobs.schedule((Callable)remoteInvocationCallable, (JobInput)Jobs.newInput().withRunContext(((RunContext)RunContext.CURRENT.get()).copy()).withName(this.createServiceRequestName(requestSequence), new Object[0]).withExceptionHandling(null, false)).whenDone(event -> {
            if (event.isCancelled()) {
                remoteInvocationCallable.cancel();
            }
        }, ((RunContext)RunContext.CURRENT.get()).copy().withRunMonitor((RunMonitor)BEANS.get(RunMonitor.class)));
        try {
            return (ServiceTunnelResponse)future.awaitDoneAndGet();
        }
        catch (ThreadInterruptedError e) {
            future.cancel(true);
            return new ServiceTunnelResponse(new ThreadInterruptedError("UserInterrupted", new Object[0]));
        }
        catch (FutureCancelledError e) {
            return new ServiceTunnelResponse(new FutureCancelledError("UserInterrupted", new Object[0]));
        }
    }

    protected void interceptHttpResponse(HttpResponse httpResponse, ServiceTunnelRequest call) {
    }

    protected String createServiceRequestName(long requestSequence) {
        IFuture currentFuture = (IFuture)IFuture.CURRENT.get();
        String submitter = currentFuture != null ? currentFuture.getJobInput().getName() : Thread.currentThread().getName();
        return String.format("Tunneling service request [seq=%s, submitter=%s]", requestSequence, submitter);
    }
}

