/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Bean
public class DefaultAuthToken {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthToken.class);
    private static final Set<Integer> DIRECT_WRITE_BYTES = IntStream.range(0, 128).filter(i -> i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57 || i == 43 || i == 45 || i == 95 || i == 46 || i == 47).boxed().collect(Collectors.toSet());
    private String m_userId;
    private long m_validUntil;
    private List<String> m_customArgs;
    private byte[] m_signature;

    public String getUserId() {
        return this.m_userId;
    }

    public String getUserIdOrAnonymous() {
        return StringUtility.hasText((CharSequence)this.m_userId) ? this.m_userId : "anonymous";
    }

    public DefaultAuthToken withUserId(String userId) {
        this.m_userId = userId;
        return this;
    }

    public long getValidUntil() {
        return this.m_validUntil;
    }

    public DefaultAuthToken withValidUntil(long validUntil) {
        this.m_validUntil = validUntil;
        return this;
    }

    protected boolean verifyUser(DefaultAuthToken token) {
        return StringUtility.hasText((CharSequence)token.getUserId());
    }

    protected boolean verifyValidUntil(DefaultAuthToken token) {
        return System.currentTimeMillis() < token.getValidUntil();
    }

    public List<String> getCustomArgs() {
        return this.m_customArgs;
    }

    public DefaultAuthToken withCustomArgs(List<String> customArgs) {
        this.m_customArgs = customArgs;
        return this;
    }

    public DefaultAuthToken withCustomArgs(String ... customArgs) {
        if (customArgs != null && customArgs.length > 0) {
            this.m_customArgs = new ArrayList<String>(Arrays.asList(customArgs));
        }
        return this;
    }

    public byte[] getSignature() {
        return this.m_signature;
    }

    public DefaultAuthToken withSignature(byte[] signature) {
        this.m_signature = signature;
        return this;
    }

    protected char partsDelimiter() {
        return ';';
    }

    protected void writeByte(ByteArrayOutputStream out, byte b) {
        int i = b & 0xFF;
        if (DIRECT_WRITE_BYTES.contains(i)) {
            out.write(i);
        } else {
            int hi = i / 16;
            int lo = i % 16;
            out.write(36);
            out.write((char)(hi <= 9 ? 48 + hi : 97 + (hi - 10)));
            out.write((char)(lo <= 9 ? 48 + lo : 97 + (lo - 10)));
        }
    }

    protected int readByte(ByteArrayInputStream in) {
        int b = in.read();
        if (b != 36 || b < 0) {
            return b;
        }
        int hi = in.read() - 48;
        int lo = in.read() - 48;
        if (hi > 9) {
            hi = hi + 48 - 97 + 10;
        }
        if (lo > 9) {
            lo = lo + 48 - 97 + 10;
        }
        return hi << 4 | lo;
    }

    public DefaultAuthToken read(String token) {
        if (!StringUtility.hasText((CharSequence)token)) {
            return this;
        }
        String[] parts = token.split(Pattern.quote("" + this.partsDelimiter()));
        if (parts == null || parts.length < 3) {
            return this;
        }
        Function<String, byte[]> bytesDecoder = s -> {
            int b;
            ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes(StandardCharsets.US_ASCII));
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            while ((b = this.readByte(in)) >= 0) {
                buf.write(b);
            }
            return buf.toByteArray();
        };
        try {
            this.withUserId(new String(bytesDecoder.apply(parts[0]), StandardCharsets.UTF_8));
            this.withValidUntil(Long.parseLong(parts[1], 16));
            if (parts.length > 3) {
                int numberOfCustomArgs = parts.length - 1;
                ArrayList<String> customArgs = new ArrayList<String>(numberOfCustomArgs);
                int i = 2;
                while (i < numberOfCustomArgs) {
                    String arg = new String(bytesDecoder.apply(parts[i]), StandardCharsets.UTF_8);
                    if (arg.isEmpty()) {
                        arg = null;
                    }
                    customArgs.add(arg);
                    ++i;
                }
                this.withCustomArgs(customArgs);
            }
            try {
                this.withSignature(bytesDecoder.apply(parts[parts.length - 1]));
            }
            catch (RuntimeException e) {
                LOG.debug("Could not decode hex string", (Throwable)e);
            }
        }
        catch (Exception ex) {
            throw new PlatformException("unexpected behaviour", new Object[]{ex});
        }
        return this;
    }

    public String write(boolean withSignature) {
        byte partsDelimiter = (byte)this.partsDelimiter();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
                Consumer<byte[]> bytesEncoder = bytes -> {
                    byte[] byArray = bytes;
                    int n = ((byte[])bytes).length;
                    int n2 = 0;
                    while (n2 < n) {
                        byte b = byArray[n2];
                        this.writeByte(out, b);
                        ++n2;
                    }
                };
                bytesEncoder.accept(this.getUserIdOrAnonymous().getBytes(StandardCharsets.UTF_8));
                out.write(partsDelimiter);
                out.write(Long.toHexString(this.getValidUntil()).getBytes());
                if (this.getCustomArgs() != null) {
                    for (String arg : this.getCustomArgs()) {
                        out.write(partsDelimiter);
                        if (arg == null) continue;
                        bytesEncoder.accept(arg.getBytes(StandardCharsets.UTF_8));
                    }
                }
                byte[] signature = this.getSignature();
                if (withSignature && signature != null && signature.length > 0) {
                    out.write(partsDelimiter);
                    bytesEncoder.accept(signature);
                }
                return out.toString(StandardCharsets.US_ASCII);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException ex) {
            throw new PlatformException("unexpected behaviour", new Object[]{ex});
        }
    }

    public String toString() {
        return this.write(true);
    }
}

