/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel.http;

import com.google.api.client.http.AbstractInputStreamContent;
import com.google.api.client.util.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ByteArrayContentEx
extends AbstractInputStreamContent {
    private final byte[] m_bytes;
    private final int m_offset;
    private final int m_length;
    private boolean m_retrySupported;

    public ByteArrayContentEx(String type, byte[] array, boolean retrySupported) {
        this(type, array, 0, array.length, retrySupported);
    }

    public ByteArrayContentEx(String type, byte[] array, int offset, int length, boolean retrySupported) {
        super(type);
        Preconditions.checkArgument((offset >= 0 && length >= 0 && offset + length <= array.length ? 1 : 0) != 0, (String)"offset %s, length %s, array length %s", (Object[])new Object[]{offset, length, array.length});
        this.m_bytes = (byte[])Preconditions.checkNotNull((Object)array);
        this.m_offset = offset;
        this.m_length = length;
        this.m_retrySupported = retrySupported;
    }

    public long getLength() {
        return this.m_length;
    }

    public boolean retrySupported() {
        return this.m_retrySupported;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.m_bytes, this.m_offset, this.m_length);
    }

    public ByteArrayContentEx setRetrySupported(boolean retrySupported) {
        this.m_retrySupported = retrySupported;
        return this;
    }

    public ByteArrayContentEx setType(String type) {
        super.setType(type);
        return this;
    }

    public ByteArrayContentEx setCloseInputStream(boolean closeInputStream) {
        super.setCloseInputStream(closeInputStream);
        return this;
    }
}

