/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.lang.reflect.Method;
import org.eclipse.scout.rt.platform.ApplicationScoped;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.util.Assertions;

@ApplicationScoped
public class ServiceUtility {
    public Method getServiceOperation(Class<?> serviceClass, String operation, Class<?>[] paramTypes) {
        Assertions.assertNotNull(serviceClass, (String)"service class is null", (Object[])new Object[0]);
        try {
            return serviceClass.getMethod(operation, paramTypes);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate((Throwable)e);
        }
    }

    public Object invoke(Object service, Method operation, Object[] args) {
        Assertions.assertNotNull((Object)service, (String)"service is null", (Object[])new Object[0]);
        Assertions.assertNotNull((Object)operation, (String)"operation is null", (Object[])new Object[0]);
        try {
            return operation.invoke(service, args != null ? args : new Object[]{});
        }
        catch (Throwable t) {
            throw ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate(t);
        }
    }
}

