/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanDecorationFactory;
import org.eclipse.scout.rt.platform.interceptor.IBeanDecorator;
import org.eclipse.scout.rt.platform.interceptor.internal.BeanProxyImplementor;
import org.eclipse.scout.rt.platform.internal.BeanImplementor;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelOptions;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelProxyProducer;

public final class ServiceTunnelUtility {
    private ServiceTunnelUtility() {
    }

    public static <T> T createProxy(Class<T> serviceInterfaceClass) {
        return ServiceTunnelUtility.createProxy(serviceInterfaceClass, null);
    }

    public static <T> T createProxy(Class<T> serviceInterfaceClass, ServiceTunnelOptions options) {
        ServiceTunnelProxyProducer tunnelProxyProducer = new ServiceTunnelProxyProducer(serviceInterfaceClass, options);
        BeanMetaData metaData = new BeanMetaData(serviceInterfaceClass).withApplicationScoped(true).withProducer(tunnelProxyProducer);
        BeanImplementor bean = new BeanImplementor(metaData);
        IBeanDecorationFactory factory = (IBeanDecorationFactory)BEANS.opt(IBeanDecorationFactory.class);
        if (factory == null) {
            return (T)bean.getInstance();
        }
        IBeanDecorator decorator = factory.decorate((IBean)bean, serviceInterfaceClass);
        if (decorator == null) {
            return (T)bean.getInstance();
        }
        return (T)new BeanProxyImplementor((IBean)bean, decorator, new Class[]{serviceInterfaceClass}).getProxy();
    }
}

