/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.VerboseUtility;

public class ServiceTunnelRequest
implements Serializable {
    private static final long serialVersionUID = 0L;
    private static final AtomicLong REQUEST_SEQUENCE_GENERATOR = new AtomicLong();
    private final long m_requestSequence = REQUEST_SEQUENCE_GENERATOR.incrementAndGet();
    private String m_sessionId;
    private final String m_serviceInterfaceClassName;
    private final String m_operation;
    private final Class[] m_parameterTypes;
    private final Object[] m_args;
    private final Locale m_locale;
    private String m_userAgent;
    private NodeId m_clientNodeId;

    public ServiceTunnelRequest(String serviceInterfaceName, String op, Class[] parameterTypes, Object[] args) {
        this.m_serviceInterfaceClassName = serviceInterfaceName;
        this.m_operation = op;
        this.m_parameterTypes = parameterTypes;
        if (args == null) {
            args = new Object[]{};
        }
        this.m_args = args;
        this.m_locale = NlsLocale.get();
    }

    public long getRequestSequence() {
        return this.m_requestSequence;
    }

    public String getSessionId() {
        return this.m_sessionId;
    }

    public void setSessionId(String sessionId) {
        this.m_sessionId = sessionId;
    }

    public String getServiceInterfaceClassName() {
        return this.m_serviceInterfaceClassName;
    }

    public String getOperation() {
        return this.m_operation;
    }

    public Class[] getParameterTypes() {
        return this.m_parameterTypes;
    }

    public Object[] getArgs() {
        return this.m_args;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getUserAgent() {
        return this.m_userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.m_userAgent = userAgent;
    }

    public NodeId getClientNodeId() {
        return this.m_clientNodeId;
    }

    public void setClientNodeId(NodeId notificationNodeId) {
        this.m_clientNodeId = notificationNodeId;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Remote call [");
        buf.append("requestSequence='").append(this.m_requestSequence).append("', ");
        buf.append("sessionId='").append(this.m_sessionId).append("'\n");
        buf.append(this.m_serviceInterfaceClassName).append(".").append(this.m_operation);
        if (this.m_args != null && this.m_args.length > 0) {
            int i = 0;
            while (i < this.m_args.length) {
                buf.append("\t\n");
                buf.append("arg[").append(i).append("]=").append(VerboseUtility.dumpObject((Object)this.m_args[i]));
                ++i;
            }
        }
        return buf.toString();
    }
}

