/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.lang.reflect.Method;
import java.util.concurrent.Callable;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanInstanceProducer;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.interceptor.DecoratingProxy;
import org.eclipse.scout.rt.platform.interceptor.IInstanceInvocationHandler;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.VerboseUtility;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelOptions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceTunnelProxyProducer<T>
implements IBeanInstanceProducer<T>,
IInstanceInvocationHandler<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ServiceTunnelProxyProducer.class);
    private final DecoratingProxy<T> m_proxy;
    private final Class<?> m_interfaceClass;
    private final ServiceTunnelOptions m_options;

    public ServiceTunnelProxyProducer(Class<?> interfaceClass) {
        this(interfaceClass, null);
    }

    public ServiceTunnelProxyProducer(Class<?> interfaceClass, ServiceTunnelOptions options) {
        this.m_interfaceClass = interfaceClass;
        this.m_options = (ServiceTunnelOptions)ObjectUtility.nvlOpt((Object)options, ServiceTunnelOptions::create);
        this.m_proxy = DecoratingProxy.newInstance((IInstanceInvocationHandler)this, (Class[])new Class[]{interfaceClass});
    }

    public T produce(IBean<T> bean) {
        return (T)this.m_proxy.getProxy();
    }

    public Object invoke(T instance, Method method, Object[] args) throws Throwable {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Tunnel call to {}.{}({})", new Object[]{this.getInterfaceClass(), method.getName(), VerboseUtility.dumpObjects((Object[])args)});
        }
        Callable<Object> invokeService = () -> ((IServiceTunnel)BEANS.get(IServiceTunnel.class)).invokeService(this.getInterfaceClass(), method, args);
        if (this.getOptions().isIdSignature()) {
            return RunContexts.copyCurrent().withProperty((Object)"ServiceTunnelOptions.idSignature", (Object)true).call(invokeService);
        }
        return invokeService.call();
    }

    protected Class<?> getInterfaceClass() {
        return this.m_interfaceClass;
    }

    public ServiceTunnelOptions getOptions() {
        return this.m_options;
    }
}

