/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.util.List;
import java.util.Optional;
import org.eclipse.scout.rt.platform.BeanMetaData;
import org.eclipse.scout.rt.platform.IBean;
import org.eclipse.scout.rt.platform.IBeanManager;
import org.eclipse.scout.rt.platform.IPlatform;
import org.eclipse.scout.rt.platform.IPlatformListener;
import org.eclipse.scout.rt.platform.PlatformEvent;
import org.eclipse.scout.rt.platform.config.CONFIG;
import org.eclipse.scout.rt.platform.inventory.ClassInventory;
import org.eclipse.scout.rt.platform.inventory.IClassInfo;
import org.eclipse.scout.rt.platform.inventory.IClassInventory;
import org.eclipse.scout.rt.shared.SharedConfigProperties;
import org.eclipse.scout.rt.shared.TunnelToServer;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelOptions;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelProxyProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterTunnelToServerPlatformListener
implements IPlatformListener {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterTunnelToServerPlatformListener.class);

    public void stateChanged(PlatformEvent event) {
        if (event.getState() == IPlatform.State.BeanManagerPrepared) {
            if (!this.isEnabled()) {
                return;
            }
            IBeanManager beanManager = event.getSource().getBeanManager();
            IClassInventory classInventory = ClassInventory.get();
            this.registerTunnelToServerProxies(beanManager, classInventory);
        }
    }

    protected boolean isEnabled() {
        return (Boolean)CONFIG.getPropertyValue(SharedConfigProperties.CreateTunnelToServerBeansProperty.class);
    }

    protected void registerTunnelToServerProxies(IBeanManager beanManager, IClassInventory classInventory) {
        for (IClassInfo ci : classInventory.getKnownAnnotatedTypes(TunnelToServer.class)) {
            if (!ci.isInterface() || !ci.isPublic()) {
                LOG.error("The annotation @{} can only be used on public interfaces, not on {}", (Object)TunnelToServer.class.getSimpleName(), (Object)ci.name());
                continue;
            }
            try {
                Class c = ci.resolveClass();
                this.registerTunnelToServerProxy(beanManager, c);
            }
            catch (Exception e) {
                LOG.warn("could not load class [{}]", (Object)ci.name(), (Object)e);
            }
        }
        LOG.info("Tunnel to server proxies registered.");
    }

    protected void registerTunnelToServerProxy(IBeanManager beanManager, Class<?> c) {
        if (!this.acceptClass(beanManager, c)) {
            LOG.debug("ignoring class [{}]", c);
            return;
        }
        beanManager.registerBean(this.createBeanMetaData(c));
        LOG.debug("Registered [{}}", c);
    }

    protected boolean acceptClass(IBeanManager beanManager, Class<?> beanClass) {
        List beans = beanManager.getBeans(beanClass);
        for (IBean bean : beans) {
            if (bean.getBeanClazz().isInterface()) continue;
            return false;
        }
        return true;
    }

    protected BeanMetaData createBeanMetaData(Class<?> c) {
        ServiceTunnelProxyProducer tunnelProxyProducer = new ServiceTunnelProxyProducer(c, ServiceTunnelOptions.create().withIdSignature(Optional.ofNullable(c).map(clazz -> clazz.getAnnotation(TunnelToServer.class)).map(TunnelToServer::idSignature).orElse(false)));
        return new BeanMetaData(c).withApplicationScoped(true).withProducer(tunnelProxyProducer);
    }
}

