/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.servicetunnel;

import java.lang.reflect.Method;
import org.eclipse.scout.rt.dataobject.id.NodeId;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.context.RunMonitor;
import org.eclipse.scout.rt.platform.exception.DefaultRuntimeExceptionTranslator;
import org.eclipse.scout.rt.platform.exception.IThrowableWithContextInfo;
import org.eclipse.scout.rt.platform.exception.PlatformException;
import org.eclipse.scout.rt.platform.util.concurrent.ThreadInterruptedError;
import org.eclipse.scout.rt.shared.ISession;
import org.eclipse.scout.rt.shared.servicetunnel.IServiceTunnel;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelRequest;
import org.eclipse.scout.rt.shared.servicetunnel.ServiceTunnelResponse;
import org.eclipse.scout.rt.shared.ui.UserAgent;
import org.eclipse.scout.rt.shared.ui.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractServiceTunnel
implements IServiceTunnel {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractServiceTunnel.class);

    @Override
    public Object invokeService(Class<?> serviceInterfaceClass, Method operation, Object[] callerArgs) {
        LOG.debug("{}.{}({})", new Object[]{serviceInterfaceClass, operation, callerArgs});
        ServiceTunnelRequest request = this.createRequest(serviceInterfaceClass, operation, callerArgs);
        this.interceptRequest(request);
        return this.invokeService(request);
    }

    public Object invokeService(ServiceTunnelRequest request) {
        long t0 = System.nanoTime();
        this.checkAlreadyCancelled(request);
        this.beforeTunnel(request);
        ServiceTunnelResponse response = this.tunnel(request);
        this.afterTunnel(t0, response);
        Throwable t = response.getException();
        if (t != null) {
            RuntimeException serviceException = this.interceptException(t);
            if (serviceException instanceof PlatformException) {
                ((IThrowableWithContextInfo)serviceException).withContextInfo("remote-service.name", (Object)request.getServiceInterfaceClassName(), new Object[0]).withContextInfo("remote-service.operation", (Object)request.getOperation(), new Object[0]);
            }
            StackTraceElement[] trace1 = serviceException.getStackTrace();
            StackTraceElement[] trace2 = new Exception().getStackTrace();
            StackTraceElement[] both = new StackTraceElement[trace1.length + trace2.length];
            System.arraycopy(trace1, 0, both, 0, trace1.length);
            System.arraycopy(trace2, 0, both, trace1.length, trace2.length);
            serviceException.setStackTrace(both);
            throw serviceException;
        }
        return response.getData();
    }

    public ServiceTunnelRequest createRequest(Class<?> interfaceClass, Method operation, Object[] args) {
        if (args == null) {
            args = new Object[]{};
        }
        return new ServiceTunnelRequest(interfaceClass.getName(), operation.getName(), operation.getParameterTypes(), args);
    }

    protected void interceptRequest(ServiceTunnelRequest request) {
        UserAgent userAgent = UserAgent.CURRENT.get();
        if (userAgent == null) {
            LOG.warn("No UserAgent set on calling context; include default in service-request");
            userAgent = UserAgents.createDefault();
        }
        request.setUserAgent(userAgent.createIdentifier());
        ISession session = ISession.CURRENT.get();
        if (session != null) {
            request.setSessionId(session.getId());
        }
        request.setClientNodeId(NodeId.current());
    }

    protected void beforeTunnel(ServiceTunnelRequest serviceRequest) {
    }

    protected void checkAlreadyCancelled(ServiceTunnelRequest serviceRequest) {
        RunMonitor monitor = (RunMonitor)RunMonitor.CURRENT.get();
        if (monitor != null && monitor.isCancelled()) {
            StringBuilder cancellationExceptionText = new StringBuilder();
            cancellationExceptionText.append("RunMonitor is already cancelled.");
            if (serviceRequest != null) {
                cancellationExceptionText.append(" (Request was '");
                cancellationExceptionText.append(serviceRequest.getServiceInterfaceClassName());
                cancellationExceptionText.append(".");
                cancellationExceptionText.append(serviceRequest.getOperation());
                cancellationExceptionText.append("(..)')");
            }
            throw new ThreadInterruptedError(cancellationExceptionText.toString(), new Object[0]);
        }
    }

    protected abstract ServiceTunnelResponse tunnel(ServiceTunnelRequest var1);

    protected void afterTunnel(long t0, ServiceTunnelResponse serviceResponse) {
    }

    protected RuntimeException interceptException(Throwable t) {
        return ((DefaultRuntimeExceptionTranslator)BEANS.get(DefaultRuntimeExceptionTranslator.class)).translate(t);
    }
}

