/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.lookup;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.lookup.ILookupCall;
import org.eclipse.scout.rt.shared.services.lookup.ILookupRow;
import org.eclipse.scout.rt.shared.services.lookup.LocalLookupCall;
import org.eclipse.scout.rt.shared.services.lookup.LookupCall;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchLookupResultCache {
    private static final Logger LOG = LoggerFactory.getLogger(BatchLookupResultCache.class);
    private static final Object globalCacheableLock = new Object();
    private static final Map<Class<? extends ILookupCall>, Boolean> globalCacheable = new HashMap<Class<? extends ILookupCall>, Boolean>();
    private final Map<ILookupCall, List<ILookupRow<?>>> m_cache = new HashMap();

    public void reset() {
        this.m_cache.clear();
    }

    public List<ILookupRow<?>> getDataByKey(ILookupCall call) {
        if (call == null || call.getKey() == null) {
            return CollectionUtility.emptyArrayList();
        }
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByKey();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByText(ILookupCall call) {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByText();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByAll(ILookupCall call) {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByAll();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getDataByRec(ILookupCall call) {
        List<ILookupRow<Object>> result = this.getCachedResult(call);
        if (result == null) {
            result = call.getDataByRec();
            this.putCachedResult(call, result);
        }
        return result;
    }

    public List<ILookupRow<?>> getCachedResult(ILookupCall call) {
        if (call == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return null;
        }
        List<ILookupRow<?>> list = this.m_cache.get(call);
        if (list == null) {
            return null;
        }
        return CollectionUtility.arrayList(list);
    }

    public void putCachedResult(ILookupCall call, List<ILookupRow<?>> result) {
        if (call == null || result == null || !BatchLookupResultCache.isCacheable(call.getClass())) {
            return;
        }
        this.m_cache.put(call, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isCacheable(Class<? extends ILookupCall> clazz) {
        if (clazz == null) {
            return false;
        }
        Object object = globalCacheableLock;
        synchronized (object) {
            Boolean b = globalCacheable.computeIfAbsent(clazz, k -> BatchLookupResultCache.verifyLookupCallBeanQuality(clazz));
            return b;
        }
    }

    private static boolean verifyLookupCallBeanQuality(Class<? extends ILookupCall> clazz) {
        if (clazz == LocalLookupCall.class) {
            return true;
        }
        if (clazz == LookupCall.class) {
            return true;
        }
        Class<? extends ILookupCall> t = clazz;
        while (t != null && t != LookupCall.class) {
            Field[] fieldArray = t.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field f = fieldArray[n2];
                if (!f.isSynthetic() && !f.isEnumConstant() && (f.getModifiers() & 8) == 0) {
                    try {
                        t.getDeclaredMethod("equals", Object.class);
                    }
                    catch (Exception ex) {
                        LOG.warn("{} subclasses LookupCall with an additional member field '{}.{}' and should therefore override the 'boolean equals(Object obj)' and 'int hashCode()' methods", new Object[]{clazz, t.getSimpleName(), f.getName()});
                        return false;
                    }
                }
                ++n2;
            }
            t = t.getSuperclass();
        }
        return true;
    }
}

