/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.file;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;

public class DecompressedInputStream
extends InputStream {
    private final ByteArrayInputStream m_buffer;
    private final Inflater m_inflater;
    private final InflaterInputStream m_inflaterInputStream;

    public DecompressedInputStream(RemoteFile f) throws IOException {
        if (f.getCompressedData() == null) {
            throw new IOException(String.valueOf(f) + " has no content");
        }
        this.m_buffer = new ByteArrayInputStream(f.getCompressedData());
        this.m_inflater = new Inflater();
        this.m_inflaterInputStream = new InflaterInputStream(this.m_buffer, this.m_inflater);
    }

    @Override
    public void close() throws IOException {
        this.m_inflaterInputStream.close();
        this.m_inflater.end();
        this.m_buffer.close();
    }

    @Override
    public int read() throws IOException {
        return this.m_inflaterInputStream.read();
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        return this.m_inflaterInputStream.read(buf, off, len);
    }
}

