/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.context;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.reflect.BasicPropertySupport;
import org.eclipse.scout.rt.platform.util.CollectionUtility;

public class SharedVariableMap
implements Serializable,
Map<String, Object> {
    private static final long serialVersionUID = 1L;
    public static final String PROP_VALUES = "values";
    private final Map<String, Object> m_variables = new HashMap<String, Object>();
    private transient BasicPropertySupport m_propertySupport = new BasicPropertySupport((Object)this);

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        this.m_propertySupport = new BasicPropertySupport((Object)this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_propertySupport.removePropertyChangeListener(listener);
    }

    public synchronized void updateInternal(Map<String, Object> newMap) {
        if (this.m_variables.equals(newMap)) {
            return;
        }
        this.m_variables.clear();
        this.putAll((Map<? extends String, ?>)newMap);
    }

    private void fireValuesChanged() {
        this.m_propertySupport.firePropertyChange(PROP_VALUES, null, (Object)CollectionUtility.copyMap(this.m_variables));
    }

    @Override
    public synchronized void clear() {
        this.m_variables.clear();
        this.fireValuesChanged();
    }

    @Override
    public synchronized boolean containsKey(Object key) {
        return this.m_variables.containsKey(key);
    }

    @Override
    public synchronized boolean containsValue(Object value) {
        return this.m_variables.containsValue(value);
    }

    @Override
    public synchronized Set<Map.Entry<String, Object>> entrySet() {
        return CollectionUtility.hashSet(this.m_variables.entrySet());
    }

    @Override
    public synchronized Object get(Object key) {
        return this.m_variables.get(key);
    }

    @Override
    public synchronized boolean isEmpty() {
        return this.m_variables.isEmpty();
    }

    @Override
    public synchronized Set<String> keySet() {
        return CollectionUtility.hashSet(this.m_variables.keySet());
    }

    @Override
    public synchronized Object put(String key, Object value) {
        Object o = this.m_variables.put(key, value);
        this.fireValuesChanged();
        return o;
    }

    @Override
    public synchronized void putAll(Map<? extends String, ?> m) {
        this.m_variables.putAll(m);
        this.fireValuesChanged();
    }

    @Override
    public synchronized Object remove(Object key) {
        Object o = this.m_variables.remove(key);
        this.fireValuesChanged();
        return o;
    }

    @Override
    public synchronized int size() {
        return this.m_variables.size();
    }

    @Override
    public synchronized Collection<Object> values() {
        return CollectionUtility.arrayList(this.m_variables.values());
    }

    public synchronized String toString() {
        return this.m_variables.toString();
    }
}

