/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code.mapping;

import java.util.List;
import java.util.function.Function;
import org.eclipse.scout.rt.api.data.ApiExposeHelper;
import org.eclipse.scout.rt.api.data.code.CodeDo;
import org.eclipse.scout.rt.api.data.code.CodeTypeDo;
import org.eclipse.scout.rt.dataobject.mapping.AbstractToDoFunction;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.mapping.AbstractCodeToDoFunction;
import org.eclipse.scout.rt.shared.services.common.code.mapping.CodeToDoFunction;
import org.eclipse.scout.rt.shared.services.common.code.mapping.ICodeTypeToDoFunction;

public abstract class AbstractCodeTypeToDoFunction<EXPLICIT_SOURCE extends ICodeType<?, ?>, EXPLICIT_TARGET extends CodeTypeDo>
extends AbstractToDoFunction<EXPLICIT_SOURCE, EXPLICIT_TARGET, ICodeType<?, ?>, CodeTypeDo>
implements ICodeTypeToDoFunction {
    private Function<Object, String> m_idConverter = AbstractCodeToDoFunction::convertId;

    protected AbstractCodeTypeToDoFunction() {
    }

    public void apply(EXPLICIT_SOURCE codeType, EXPLICIT_TARGET codeTypeDo) {
        String id = this.getIdConverter().apply(codeType.getId());
        String currentLanguageTag = NlsLocale.get().toLanguageTag();
        String iconId = codeType.getIconId();
        List<CodeDo> codes = ((CodeToDoFunction)BEANS.get(CodeToDoFunction.class)).codesToDos(this.getCodesToConvert(codeType));
        String text = codeType.getText();
        String textPlural = codeType.getTextPlural();
        boolean isHierarchy = codeType.isHierarchy();
        int maxLevel = codeType.getMaxLevel();
        codeTypeDo.withId(id);
        if (StringUtility.hasText((CharSequence)text)) {
            codeTypeDo.withText(currentLanguageTag, text);
        }
        if (StringUtility.hasText((CharSequence)textPlural)) {
            codeTypeDo.withTextPlural(currentLanguageTag, textPlural);
        }
        if (StringUtility.hasText((CharSequence)iconId)) {
            codeTypeDo.withIconId(iconId);
        }
        if (isHierarchy) {
            codeTypeDo.withHierarchical(Boolean.valueOf(isHierarchy));
        }
        if (maxLevel != Integer.MAX_VALUE) {
            codeTypeDo.withMaxLevel(Integer.valueOf(maxLevel));
        }
        if (!codes.isEmpty()) {
            codeTypeDo.withCodes(codes);
        }
        if (Platform.get().inDevelopmentMode()) {
            codeTypeDo.withModelClass(codeType.getClass().getName());
        }
        ((ApiExposeHelper)BEANS.get(ApiExposeHelper.class)).setObjectTypeToDo(codeType, codeTypeDo);
    }

    protected List<? extends ICode<?>> getCodesToConvert(EXPLICIT_SOURCE codeType) {
        return codeType.getCodes(false);
    }

    public Function<Object, String> getIdConverter() {
        return this.m_idConverter;
    }

    public void setIdConverter(Function<Object, String> idConverter) {
        if (idConverter == null) {
            return;
        }
        this.m_idConverter = idConverter;
    }
}

