/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code.mapping;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.scout.rt.api.data.ApiExposeHelper;
import org.eclipse.scout.rt.api.data.code.CodeDo;
import org.eclipse.scout.rt.dataobject.id.IId;
import org.eclipse.scout.rt.dataobject.id.IdCodec;
import org.eclipse.scout.rt.dataobject.mapping.AbstractToDoFunction;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Bean;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.Platform;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.StringUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.mapping.ICodeToDoFunction;

public abstract class AbstractCodeToDoFunction<EXPLICIT_SOURCE extends ICode<?>, EXPLICIT_TARGET extends CodeDo>
extends AbstractToDoFunction<EXPLICIT_SOURCE, EXPLICIT_TARGET, ICode<?>, CodeDo>
implements ICodeToDoFunction {
    private Function<Object, String> m_idConverter = AbstractCodeToDoFunction::convertId;

    protected AbstractCodeToDoFunction() {
    }

    public void apply(EXPLICIT_SOURCE code, EXPLICIT_TARGET codeDo) {
        String id = this.getIdConverter().apply(code.getId());
        List<CodeDo> codes = this.codesToDos(this.getChildCodesToConvert(code));
        boolean active = code.isActive();
        boolean enabled = code.isEnabled();
        String iconId = code.getIconId();
        String tooltipText = code.getTooltipText();
        String backgroundColor = code.getBackgroundColor();
        String foregroundColor = code.getForegroundColor();
        String cssClass = code.getCssClass();
        String extKey = code.getExtKey();
        Number value = code.getValue();
        long partitionId = code.getPartitionId();
        String text = code.getText();
        FontSpec font = code.getFont();
        String fieldName = this.computeFieldName(code);
        ICodeType codeType = code.getCodeType();
        codeDo.withId(id).withActive(Boolean.valueOf(active)).withEnabled(Boolean.valueOf(enabled));
        if (StringUtility.hasText((CharSequence)iconId)) {
            codeDo.withIconId(iconId);
        }
        if (StringUtility.hasText((CharSequence)tooltipText)) {
            codeDo.withTooltipText(tooltipText);
        }
        if (StringUtility.hasText((CharSequence)backgroundColor)) {
            codeDo.withBackgroundColor(backgroundColor);
        }
        if (StringUtility.hasText((CharSequence)foregroundColor)) {
            codeDo.withForegroundColor(foregroundColor);
        }
        if (StringUtility.hasText((CharSequence)cssClass)) {
            codeDo.withCssClass(cssClass);
        }
        if (StringUtility.hasText((CharSequence)extKey)) {
            codeDo.withExtKey(extKey);
        }
        if (value != null) {
            codeDo.withValue(value);
        }
        if (partitionId != 0L) {
            codeDo.withPartitionId(Long.valueOf(partitionId));
        }
        if (StringUtility.hasText((CharSequence)text)) {
            codeDo.withText(NlsLocale.get().toLanguageTag(), text);
        }
        if (!codes.isEmpty()) {
            codeDo.withChildren(codes);
        }
        if (font != null) {
            codeDo.withFont(font.toPattern());
        }
        if (Platform.get().inDevelopmentMode()) {
            codeDo.withModelClass(code.getClass().getName());
        }
        if (StringUtility.hasText((CharSequence)fieldName)) {
            codeDo.withFieldName(fieldName);
        }
        if (codeType != null) {
            codeDo.withSortCode(Integer.valueOf(codeType.getCodeIndex(code)));
        }
        ((ApiExposeHelper)BEANS.get(ApiExposeHelper.class)).setObjectTypeToDo(code, codeDo);
    }

    protected String computeFieldName(EXPLICIT_SOURCE code) {
        String fieldName = ((ApiExposeHelper)BEANS.get(ApiExposeHelper.class)).fieldNameOf(code);
        if (fieldName != null) {
            return fieldName;
        }
        String simpleName = code.getClass().getSimpleName();
        return StringUtility.lowercaseFirst((String)StringUtility.removeSuffixes((String)simpleName, (String[])new String[]{"Code"}));
    }

    protected List<? extends ICode<?>> getChildCodesToConvert(EXPLICIT_SOURCE code) {
        return code.getChildCodes(false);
    }

    public List<CodeDo> codesToDos(Collection<? extends ICode<?>> codesToExport) {
        if (CollectionUtility.isEmpty(codesToExport)) {
            return Collections.emptyList();
        }
        return codesToExport.stream().filter(Objects::nonNull).map(ICode::toDo).filter(Objects::nonNull).filter(code -> code.getId() != null).collect(Collectors.toList());
    }

    public Function<Object, String> getIdConverter() {
        return this.m_idConverter;
    }

    public void setIdConverter(Function<Object, String> idConverter) {
        if (idConverter == null) {
            return;
        }
        this.m_idConverter = idConverter;
    }

    public static String convertId(Object id) {
        if (id == null) {
            return null;
        }
        return BEANS.all(ICodeTypeDoIdConverter.class).stream().map(converter -> (String)converter.apply(id)).filter(Objects::nonNull).findFirst().orElseGet(() -> id.toString());
    }

    @Bean
    public static interface ICodeTypeDoIdConverter
    extends Function<Object, String> {
    }

    @Order(value=-5000.0)
    public static class IIdCodeTypeDoIdConverter
    implements ICodeTypeDoIdConverter {
        @Override
        public String apply(Object id) {
            if (id instanceof IId) {
                return ((IdCodec)BEANS.get(IdCodec.class)).toQualified((IId)id, new IdCodec.IIdCodecFlag[]{IdCodec.IdCodecFlag.SIGNATURE});
            }
            return null;
        }
    }
}

