/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.Serializable;
import java.util.Locale;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.util.ToStringBuilder;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

public class CodeTypeCacheKey
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Locale m_locale;
    private final Class<? extends ICodeType<?, ?>> m_codeTypeClass;

    public CodeTypeCacheKey(Class<? extends ICodeType<?, ?>> codeTypeClass) {
        this(NlsLocale.get(), codeTypeClass);
    }

    public CodeTypeCacheKey(Locale locale, Class<? extends ICodeType<?, ?>> codeTypeClass) {
        this.m_locale = locale;
        this.m_codeTypeClass = codeTypeClass;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public Class<? extends ICodeType<?, ?>> getCodeTypeClass() {
        return this.m_codeTypeClass;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.attr("locale", (Object)this.getLocale());
        builder.attr("codeTypeClass", this.getCodeTypeClass());
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.m_codeTypeClass == null ? 0 : this.m_codeTypeClass.hashCode());
        result = 31 * result + (this.m_locale == null ? 0 : this.m_locale.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CodeTypeCacheKey other = (CodeTypeCacheKey)obj;
        if (this.m_codeTypeClass == null ? other.m_codeTypeClass != null : !this.m_codeTypeClass.equals(other.m_codeTypeClass)) {
            return false;
        }
        return !(this.m_locale == null ? other.m_locale != null : !this.m_locale.equals(other.m_locale));
    }
}

