/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheKey;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;

public class CodeTypeCacheEntryFilter
implements ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> {
    private static final long serialVersionUID = 1L;
    private final Set<Class<? extends ICodeType<?, ?>>> m_codeTypeClasses;

    public CodeTypeCacheEntryFilter(Class<? extends ICodeType<?, ?>> codeTypeClass) {
        this.m_codeTypeClasses = CollectionUtility.hashSet(codeTypeClass);
    }

    public CodeTypeCacheEntryFilter(Collection<Class<? extends ICodeType<?, ?>>> codeTypeClasses) {
        this.m_codeTypeClasses = CollectionUtility.hashSetWithoutNullElements(codeTypeClasses);
    }

    public Set<Class<? extends ICodeType<?, ?>>> getCodeTypeClasses() {
        return Collections.unmodifiableSet(this.m_codeTypeClasses);
    }

    public boolean accept(CodeTypeCacheKey key, ICodeType<?, ?> value) {
        return this.m_codeTypeClasses.contains(key.getCodeTypeClass());
    }

    public ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> coalesce(ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> other) {
        if (other instanceof CodeTypeCacheEntryFilter) {
            HashSet newSet = new HashSet(this.m_codeTypeClasses);
            newSet.addAll(((CodeTypeCacheEntryFilter)other).m_codeTypeClasses);
            return new CodeTypeCacheEntryFilter(newSet);
        }
        return null;
    }

    public String toString() {
        return "CodeTypeCacheEntryFilter [m_codeTypeClasses=" + String.valueOf(this.m_codeTypeClasses) + "]";
    }
}

