/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import jakarta.annotation.PostConstruct;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.CreateImmediately;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.cache.AbstractCacheWrapper;
import org.eclipse.scout.rt.platform.cache.ICache;
import org.eclipse.scout.rt.platform.cache.ICacheBuilder;
import org.eclipse.scout.rt.platform.cache.ICacheEntryFilter;
import org.eclipse.scout.rt.platform.cache.ICacheInvalidationListener;
import org.eclipse.scout.rt.platform.cache.ICacheValueResolver;
import org.eclipse.scout.rt.platform.context.RunContexts;
import org.eclipse.scout.rt.platform.exception.ExceptionHandler;
import org.eclipse.scout.rt.platform.exception.PlatformExceptionTranslator;
import org.eclipse.scout.rt.platform.holders.Holder;
import org.eclipse.scout.rt.platform.nls.NlsLocale;
import org.eclipse.scout.rt.platform.transaction.TransactionScope;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.platform.util.ObjectUtility;
import org.eclipse.scout.rt.platform.util.event.FastListenerList;
import org.eclipse.scout.rt.platform.util.event.IFastListenerList;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheEntryFilter;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheKey;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeCacheUtility;
import org.eclipse.scout.rt.shared.services.common.code.CodeTypeClassInventory;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeService;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;

@Order(value=5100.0)
@CreateImmediately
public class CodeService
implements ICodeService {
    public static final String CODE_SERVICE_CACHE_ID = CodeService.class.getName();
    private volatile ICache<CodeTypeCacheKey, ICodeType<?, ?>> m_cache;
    private volatile IFastListenerList<ICacheInvalidationListener<CodeTypeCacheKey, ICodeType<?, ?>>> m_invalidationListeners;

    @PostConstruct
    protected void initCache() {
        this.m_invalidationListeners = new FastListenerList();
        this.m_cache = this.createCacheBuilder().build();
    }

    protected ICacheBuilder<CodeTypeCacheKey, ICodeType<?, ?>> createCacheBuilder() {
        ICacheBuilder cacheBuilder = (ICacheBuilder)BEANS.get(ICacheBuilder.class);
        return cacheBuilder.withCacheId(CODE_SERVICE_CACHE_ID).withValueResolver(this.createCacheValueResolver()).withShared(true).withClusterEnabled(true).withAdditionalCustomWrapper(InvalidationListenerWrapper.class, new Object[0]).withTransactional(true).withTransactionalFastForward(true);
    }

    protected ICacheValueResolver<CodeTypeCacheKey, ICodeType<?, ?>> createCacheValueResolver() {
        return key -> (ICodeType)RunContexts.copyCurrent((boolean)true).withLocale(key.getLocale()).withTransactionScope(TransactionScope.REQUIRED).call(() -> {
            try {
                return key.getCodeTypeClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw ((PlatformExceptionTranslator)BEANS.get(PlatformExceptionTranslator.class)).translate((Throwable)e).withContextInfo("key", key, new Object[0]).withContextInfo("codeTypeClass", key.getCodeTypeClass(), new Object[0]);
            }
        });
    }

    protected ICache<CodeTypeCacheKey, ICodeType<?, ?>> getCache() {
        return this.m_cache;
    }

    protected <T extends ICodeType<?, ?>> CodeTypeCacheKey createCacheKey(Class<T> type) {
        return ((CodeTypeCacheUtility)BEANS.get(CodeTypeCacheUtility.class)).createCacheKey(type);
    }

    @Override
    public void addInvalidationListener(ICacheInvalidationListener<CodeTypeCacheKey, ICodeType<?, ?>> listener) {
        if (listener != null) {
            this.m_invalidationListeners.add(listener);
        }
    }

    @Override
    public void removeInvalidationListener(ICacheInvalidationListener<CodeTypeCacheKey, ICodeType<?, ?>> listener) {
        if (listener != null) {
            this.m_invalidationListeners.remove(listener);
        }
    }

    @Override
    public List<ICacheInvalidationListener<CodeTypeCacheKey, ICodeType<?, ?>>> getInvalidationListeners() {
        return this.m_invalidationListeners.list();
    }

    @Override
    public <T extends ICodeType<?, ?>> T getCodeType(Class<T> type) {
        return (T)((ICodeType)this.getCache().get((Object)this.createCacheKey(type)));
    }

    @Override
    public <T> ICodeType<T, ?> findCodeTypeById(T id) {
        if (id == null) {
            return null;
        }
        ICodeType<T, ?> ct = this.findCodeTypeByIdInternal(id);
        if (ct != null) {
            return ct;
        }
        this.getAllCodeTypes();
        return this.findCodeTypeByIdInternal(id);
    }

    protected <T> ICodeType<T, ?> findCodeTypeByIdInternal(T id) {
        Locale locale = NlsLocale.get();
        for (Map.Entry entry : this.getCache().getUnmodifiableMap().entrySet()) {
            ICodeType ct;
            CodeTypeCacheKey key = (CodeTypeCacheKey)entry.getKey();
            if (!ObjectUtility.equals((Object)key.getLocale(), (Object)locale) || (ct = (ICodeType)entry.getValue()) == null || !id.equals(ct.getId())) continue;
            return ct;
        }
        return null;
    }

    @Override
    public List<ICodeType<?, ?>> getCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        ArrayList result = new ArrayList();
        if (CollectionUtility.isEmpty(types)) {
            return result;
        }
        Map<Class<ICodeType<?, ?>>, ICodeType<?, ?>> codeTypeMap = this.getCodeTypeMap(types);
        for (Class<? extends ICodeType<?, ?>> clazz : types) {
            result.add(codeTypeMap.get(clazz));
        }
        return result;
    }

    @Override
    public Map<Class<? extends ICodeType<?, ?>>, ICodeType<?, ?>> getCodeTypeMap(Collection<Class<? extends ICodeType<?, ?>>> types) {
        HashMap result = new HashMap();
        if (CollectionUtility.isEmpty(types)) {
            return result;
        }
        ArrayList<CodeTypeCacheKey> keys = new ArrayList<CodeTypeCacheKey>();
        HashMap<CodeTypeCacheKey, Set> requestedCodeTypesByCacheKey = new HashMap<CodeTypeCacheKey, Set>();
        for (Class<ICodeType<?, ?>> clazz : types) {
            CodeTypeCacheKey cacheKey = this.createCacheKey(clazz);
            Set requestedCodeTypes = requestedCodeTypesByCacheKey.computeIfAbsent(cacheKey, k -> new HashSet());
            requestedCodeTypes.add(clazz);
            keys.add(cacheKey);
        }
        Map map = this.getCache().getAll(keys);
        for (Map.Entry entry : map.entrySet()) {
            CodeTypeCacheKey cacheKey = (CodeTypeCacheKey)entry.getKey();
            Set requestedCodeTypes = (Set)requestedCodeTypesByCacheKey.get(cacheKey);
            for (Class requestedCodeType : requestedCodeTypes) {
                result.put(requestedCodeType, (ICodeType)entry.getValue());
            }
        }
        return result;
    }

    @Override
    public <CODE extends ICode<?>> CODE getCode(Class<CODE> type) {
        Class<CODE> typeClass = type;
        Class declaringCodeTypeClass = this.getDeclaringCodeTypeClass(typeClass);
        ICodeType codeType = this.getCodeType(declaringCodeTypeClass);
        return (CODE)((ICode)this.findCode(type, codeType));
    }

    protected <T> Class<? extends ICodeType<?, T>> getDeclaringCodeTypeClass(Class<? extends ICode<T>> type) {
        if (type == null) {
            return null;
        }
        Class<?> declaringCodeTypeClass = null;
        if (type.getDeclaringClass() != null) {
            Class<?> c = type.getDeclaringClass();
            while (c != null && !ICodeType.class.isAssignableFrom(c)) {
                c = c.getDeclaringClass();
            }
            declaringCodeTypeClass = c;
        }
        if (declaringCodeTypeClass == null) {
            try {
                declaringCodeTypeClass = type.getConstructor(new Class[0]).newInstance(new Object[0]).getCodeType().getClass();
            }
            catch (Exception e) {
                ((ExceptionHandler)BEANS.get(ExceptionHandler.class)).handle((Throwable)e);
            }
        }
        return declaringCodeTypeClass;
    }

    protected <T> T findCode(Class<T> type, ICodeType codeType) {
        if (codeType == null) {
            return null;
        }
        Holder codeHolder = new Holder(ICode.class);
        ICodeVisitor<ICode> v = (code, treeLevel) -> {
            if (code.getClass() == type) {
                codeHolder.setValue((Object)code);
                return false;
            }
            return true;
        };
        codeType.visit(v);
        return (T)codeHolder.getValue();
    }

    @Override
    public <T extends ICodeType<?, ?>> T reloadCodeType(Class<T> type) {
        this.invalidateCodeType(type);
        return this.getCodeType(type);
    }

    @Override
    public List<ICodeType<?, ?>> reloadCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        this.invalidateCodeTypes(types);
        return this.getCodeTypes(types);
    }

    @Override
    public <T extends ICodeType<?, ?>> void invalidateCodeType(Class<T> type) {
        if (type == null) {
            return;
        }
        this.getCache().invalidate((ICacheEntryFilter)((CodeTypeCacheUtility)BEANS.get(CodeTypeCacheUtility.class)).createEntryFilter(type), true);
    }

    @Override
    public void invalidateCodeTypes(List<Class<? extends ICodeType<?, ?>>> types) {
        CodeTypeCacheEntryFilter filter = ((CodeTypeCacheUtility)BEANS.get(CodeTypeCacheUtility.class)).createEntryFilter(types);
        if (filter.getCodeTypeClasses().isEmpty()) {
            return;
        }
        this.getCache().invalidate((ICacheEntryFilter)filter, true);
    }

    @Override
    public Set<Class<? extends ICodeType<?, ?>>> getAllCodeTypeClasses() {
        return ((CodeTypeClassInventory)((Object)BEANS.get(CodeTypeClassInventory.class))).getClasses();
    }

    public List<ICodeType<?, ?>> getAllCodeTypes() {
        Set<Class<? extends ICodeType<?, ?>>> allCodeTypeClasses = this.getAllCodeTypeClasses();
        ArrayList list = CollectionUtility.arrayList(allCodeTypeClasses);
        return this.getCodeTypes(list);
    }

    protected static class InvalidationListenerWrapper
    extends AbstractCacheWrapper<CodeTypeCacheKey, ICodeType<?, ?>> {
        public InvalidationListenerWrapper(ICache<CodeTypeCacheKey, ICodeType<?, ?>> delegate) {
            super(delegate);
        }

        public void invalidate(ICacheEntryFilter<CodeTypeCacheKey, ICodeType<?, ?>> filter, boolean propagate) {
            super.invalidate(filter, propagate);
            ((CodeService)BEANS.get(CodeService.class)).getInvalidationListeners().forEach(l -> l.invalidated(filter, propagate));
        }
    }
}

