/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import org.eclipse.scout.rt.platform.util.TypeCastUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.data.basic.table.AbstractTableRowData;
import org.eclipse.scout.rt.shared.services.common.code.ICodeRow;
import org.eclipse.scout.rt.shared.services.lookup.LookupRow;

public class CodeRow<ID_TYPE>
extends LookupRow<ID_TYPE>
implements ICodeRow<ID_TYPE> {
    private static final long serialVersionUID = 0L;
    private String m_extKey;
    private Number m_value;
    private long m_partitionId;
    private double m_order;

    protected CodeRow(Object[] cells) {
        this(cells, cells.length - 1);
    }

    protected CodeRow(Object[] cells, int maxColumnIndex) {
        this(cells, maxColumnIndex, (Class<ID_TYPE>)null);
    }

    public CodeRow(Object[] cells, Class<? extends ID_TYPE> clazz) {
        this(cells, cells.length - 1, clazz);
    }

    public CodeRow(Object[] cells, int maxColumnIndex, Class<? extends ID_TYPE> clazz) {
        super(null, (String)null);
        Class aClazz = clazz;
        if (aClazz == null) {
            aClazz = TypeCastUtility.getGenericsParameterClass(this.getClass(), CodeRow.class);
        }
        if (cells != null) {
            int index = 0;
            while (index < cells.length && index <= maxColumnIndex) {
                if (cells[index] != null) {
                    switch (index) {
                        case 0: {
                            Object key = TypeCastUtility.castValue((Object)cells[index], (Class)aClazz);
                            this.withKey(key);
                            break;
                        }
                        case 1: {
                            this.withText(cells[index].toString());
                            break;
                        }
                        case 2: {
                            this.withIconId(cells[index].toString());
                            break;
                        }
                        case 3: {
                            this.withTooltipText(cells[index].toString());
                            break;
                        }
                        case 4: {
                            this.withBackgroundColor(cells[index].toString());
                            break;
                        }
                        case 5: {
                            this.withForegroundColor(cells[index].toString());
                            break;
                        }
                        case 6: {
                            this.withFont(FontSpec.parse(cells[index].toString()));
                            break;
                        }
                        case 7: {
                            Boolean b = (Boolean)TypeCastUtility.castValue((Object)cells[index], Boolean.class);
                            this.withActive(b);
                            break;
                        }
                        case 8: {
                            Object o = TypeCastUtility.castValue((Object)cells[index], (Class)aClazz);
                            if (o instanceof Number && ((Number)o).longValue() == 0L) {
                                o = null;
                            }
                            this.withParentKey(o);
                            break;
                        }
                        case 9: {
                            this.m_extKey = cells[index].toString();
                            break;
                        }
                        case 10: {
                            Object o = cells[index];
                            if (!(o instanceof Number)) break;
                            this.m_value = (Number)o;
                            break;
                        }
                        case 11: {
                            Boolean b = (Boolean)TypeCastUtility.castValue((Object)cells[index], Boolean.class);
                            this.withEnabled(b);
                            break;
                        }
                        case 12: {
                            this.m_partitionId = ((Number)cells[index]).longValue();
                            break;
                        }
                        case 13: {
                            Double val = (Double)TypeCastUtility.castValue((Object)cells[index], Double.class);
                            if (val != null) {
                                this.withOrder(val);
                                break;
                            }
                            this.withOrder(9.876543212345678E16);
                        }
                    }
                }
                ++index;
            }
        }
    }

    public CodeRow(ICodeRow<ID_TYPE> t) {
        this(t.getKey(), t.getText(), t.getIconId(), t.getTooltipText(), t.getBackgroundColor(), t.getForegroundColor(), t.getFont(), t.getCssClass(), t.isEnabled(), t.getParentKey(), t.isActive(), t.getExtKey(), t.getValue(), t.getPartitionId(), t.getOrder());
    }

    public CodeRow(ID_TYPE key, String text) {
        super(key, text);
        this.m_order = Double.MAX_VALUE;
    }

    public CodeRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, String cssClass, boolean enabled, ID_TYPE parentKey, boolean active, String extKey, Number value, long partitionId) {
        this(key, text, iconId, tooltip, backgroundColor, foregroundColor, font, cssClass, enabled, parentKey, active, extKey, value, partitionId, 9.876543212345678E16);
    }

    public CodeRow(ID_TYPE key, String text, String iconId, String tooltip, String backgroundColor, String foregroundColor, FontSpec font, String cssClass, boolean enabled, ID_TYPE parentKey, boolean active, String extKey, Number value, long partitionId, double order) {
        super(key, text);
        this.withIconId(iconId);
        this.withTooltipText(tooltip);
        this.withBackgroundColor(backgroundColor);
        this.withForegroundColor(foregroundColor);
        this.withFont(font);
        this.withCssClass(cssClass);
        this.withActive(active);
        this.withEnabled(enabled);
        this.withParentKey((Object)parentKey);
        this.m_extKey = extKey;
        this.m_value = value;
        this.m_partitionId = partitionId;
        this.m_order = order;
    }

    @Override
    public CodeRow<ID_TYPE> withKey(ID_TYPE key) {
        return (CodeRow)super.withKey((Object)key);
    }

    @Override
    public CodeRow<ID_TYPE> withText(String text) {
        return (CodeRow)super.withText(text);
    }

    @Override
    public CodeRow<ID_TYPE> withIconId(String iconId) {
        return (CodeRow)super.withIconId(iconId);
    }

    @Override
    public CodeRow<ID_TYPE> withTooltipText(String tooltipText) {
        return (CodeRow)super.withTooltipText(tooltipText);
    }

    @Override
    public CodeRow<ID_TYPE> withForegroundColor(String foregroundColor) {
        return (CodeRow)super.withForegroundColor(foregroundColor);
    }

    @Override
    public CodeRow<ID_TYPE> withBackgroundColor(String backgroundColor) {
        return (CodeRow)super.withBackgroundColor(backgroundColor);
    }

    @Override
    public CodeRow<ID_TYPE> withFont(FontSpec font) {
        return (CodeRow)super.withFont(font);
    }

    @Override
    public CodeRow<ID_TYPE> withActive(boolean active) {
        return (CodeRow)super.withActive(active);
    }

    @Override
    public CodeRow<ID_TYPE> withEnabled(boolean enabled) {
        return (CodeRow)super.withEnabled(enabled);
    }

    @Override
    public CodeRow<ID_TYPE> withParentKey(ID_TYPE parentKey) {
        return (CodeRow)super.withParentKey((Object)parentKey);
    }

    @Override
    public CodeRow<ID_TYPE> withAdditionalTableRowData(AbstractTableRowData bean) {
        return (CodeRow)super.withAdditionalTableRowData(bean);
    }

    @Override
    public CodeRow<ID_TYPE> withCssClass(String cssClass) {
        return (CodeRow)super.withCssClass(cssClass);
    }

    @Override
    public String getExtKey() {
        return this.m_extKey;
    }

    @Override
    public CodeRow<ID_TYPE> withExtKey(String extKey) {
        this.m_extKey = extKey;
        return this;
    }

    @Override
    public Number getValue() {
        return this.m_value;
    }

    @Override
    public CodeRow<ID_TYPE> withValue(Number value) {
        this.m_value = value;
        return this;
    }

    @Override
    public long getPartitionId() {
        return this.m_partitionId;
    }

    @Override
    public CodeRow<ID_TYPE> withPartitionId(long partitionId) {
        this.m_partitionId = partitionId;
        return this;
    }

    @Override
    public double getOrder() {
        return this.m_order;
    }

    @Override
    public CodeRow<ID_TYPE> withOrder(double order) {
        this.m_order = order;
        return this;
    }
}

