/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.scout.rt.api.data.code.CodeTypeDo;
import org.eclipse.scout.rt.api.data.code.IApiExposedCodeTypeDoProvider;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.util.CollectionUtility;
import org.eclipse.scout.rt.shared.services.common.code.IApiExposedCodeTypeContributor;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.mapping.CodeTypeToDoFunction;

public class ApiExposedCodeTypeDoProvider
implements IApiExposedCodeTypeDoProvider {
    public Set<CodeTypeDo> provide() {
        return this.provide(null);
    }

    public Set<CodeTypeDo> provide(Set<String> ids) {
        Stream<Object> codeTypeStream = this.getExposedCodeTypes().stream();
        if (CollectionUtility.hasElements(ids)) {
            Function<Object, String> codeTypeIdConverter = ((CodeTypeToDoFunction)BEANS.get(CodeTypeToDoFunction.class)).getIdConverter();
            codeTypeStream = codeTypeStream.filter(codeType -> ids.contains(codeTypeIdConverter.apply(codeType.getId())));
        }
        return codeTypeStream.map(ICodeType::toDo).filter(Objects::nonNull).filter(codeType -> codeType.getId() != null).collect(Collectors.toSet());
    }

    public Set<ICodeType> getExposedCodeTypes() {
        HashSet<ICodeType> codeTypes = new HashSet<ICodeType>();
        BEANS.all(IApiExposedCodeTypeContributor.class).forEach(contributor -> contributor.contribute(codeTypes));
        return codeTypes;
    }
}

