/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.shared.services.common.code;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.scout.rt.api.data.code.CodeDo;
import org.eclipse.scout.rt.dataobject.mapping.ToDoFunctionHelper;
import org.eclipse.scout.rt.platform.BEANS;
import org.eclipse.scout.rt.platform.Order;
import org.eclipse.scout.rt.platform.OrderedComparator;
import org.eclipse.scout.rt.platform.annotations.ConfigOperation;
import org.eclipse.scout.rt.platform.annotations.ConfigProperty;
import org.eclipse.scout.rt.platform.classid.ClassId;
import org.eclipse.scout.rt.platform.reflect.ConfigurationUtility;
import org.eclipse.scout.rt.shared.data.basic.FontSpec;
import org.eclipse.scout.rt.shared.extension.AbstractSerializableExtension;
import org.eclipse.scout.rt.shared.extension.ContributionComposite;
import org.eclipse.scout.rt.shared.extension.IContributionOwner;
import org.eclipse.scout.rt.shared.extension.IExtensibleObject;
import org.eclipse.scout.rt.shared.extension.IExtension;
import org.eclipse.scout.rt.shared.extension.ObjectExtensions;
import org.eclipse.scout.rt.shared.extension.services.common.code.CodeChains;
import org.eclipse.scout.rt.shared.extension.services.common.code.ICodeExtension;
import org.eclipse.scout.rt.shared.services.common.code.CodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICode;
import org.eclipse.scout.rt.shared.services.common.code.ICodeRow;
import org.eclipse.scout.rt.shared.services.common.code.ICodeType;
import org.eclipse.scout.rt.shared.services.common.code.ICodeVisitor;
import org.eclipse.scout.rt.shared.services.common.code.mapping.ICodeToDoFunction;

@ClassId(value="8a1ed7c8-14e0-42ba-a275-258a3c2c4a51")
public abstract class AbstractCode<T>
implements ICode<T>,
Serializable,
IContributionOwner,
IExtensibleObject {
    private static final long serialVersionUID = 1L;
    private transient ICodeType<?, T> m_codeType;
    private ICodeRow<T> m_row;
    private transient ICode<T> m_parentCode;
    private transient Map<T, ICode<T>> m_codeMap = null;
    private List<ICode<T>> m_codeList = null;
    protected IContributionOwner m_contributionHolder;
    private final ObjectExtensions<AbstractCode<T>, ICodeExtension<T, ? extends AbstractCode<T>>> m_objectExtensions;

    @Override
    public final List<Object> getAllContributions() {
        return this.m_contributionHolder.getAllContributions();
    }

    public final <TYPE> List<TYPE> getContributionsByClass(Class<TYPE> type) {
        return this.m_contributionHolder.getContributionsByClass(type);
    }

    public final <TYPE> TYPE getContribution(Class<TYPE> contribution) {
        return this.m_contributionHolder.getContribution(contribution);
    }

    public final <TYPE> TYPE optContribution(Class<TYPE> contribution) {
        return this.m_contributionHolder.optContribution(contribution);
    }

    public AbstractCode() {
        this(true);
    }

    public AbstractCode(boolean callInitializer) {
        this(null, callInitializer);
    }

    public AbstractCode(ICodeRow<T> row) {
        this(row, true);
    }

    public AbstractCode(ICodeRow<T> row, boolean callInitializer) {
        this.m_row = row;
        this.m_objectExtensions = new ObjectExtensions(this, false);
        if (callInitializer) {
            this.callInitializer();
        }
    }

    protected final void callInitializer() {
        this.interceptInitConfig();
    }

    @ConfigProperty(value="TEXT")
    @Order(value=50.0)
    protected String getConfiguredText() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=60.0)
    protected boolean getConfiguredActive() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=65.0)
    protected boolean getConfiguredEnabled() {
        return true;
    }

    @ConfigProperty(value="ICON_ID")
    @Order(value=40.0)
    protected String getConfiguredIconId() {
        return null;
    }

    @ConfigProperty(value="TEXT")
    @Order(value=70.0)
    protected String getConfiguredTooltipText() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=20.0)
    protected String getConfiguredBackgroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=10.0)
    protected String getConfiguredForegroundColor() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=30.0)
    protected String getConfiguredFont() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=40.0)
    protected String getConfiguredCssClass() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=80.0)
    protected Double getConfiguredValue() {
        return null;
    }

    @ConfigProperty(value="STRING")
    @Order(value=80.0)
    protected String getConfiguredExtKey() {
        return null;
    }

    @ConfigProperty(value="DOUBLE")
    @Order(value=90.0)
    protected double getConfiguredViewOrder() {
        return 9.876543212345678E16;
    }

    protected double calculateViewOrder() {
        double viewOrder = this.getConfiguredViewOrder();
        Class<?> cls = this.getClass();
        if (viewOrder == 9.876543212345678E16) {
            while (cls != null && ICode.class.isAssignableFrom(cls)) {
                if (cls.isAnnotationPresent(Order.class)) {
                    Order order = cls.getAnnotation(Order.class);
                    return order.value();
                }
                cls = cls.getSuperclass();
            }
        }
        return viewOrder;
    }

    protected final List<Class<ICode>> getConfiguredCodes() {
        Class[] dca = ConfigurationUtility.getDeclaredPublicClasses(this.getClass());
        return ConfigurationUtility.filterClasses((Class[])dca, ICode.class);
    }

    protected final void interceptInitConfig() {
        this.m_objectExtensions.initConfig(this.createLocalExtension(), this::initConfig);
    }

    protected void initConfig() {
        if (this.m_row == null) {
            this.m_row = this.interceptCodeRow(new CodeRow<Object>(this.getId(), this.getConfiguredText(), this.getConfiguredIconId(), this.getConfiguredTooltipText(), this.getConfiguredBackgroundColor(), this.getConfiguredForegroundColor(), FontSpec.parse(this.getConfiguredFont()), this.getConfiguredCssClass(), this.getConfiguredEnabled(), null, this.getConfiguredActive(), this.getConfiguredExtKey(), this.getConfiguredValue(), 0L, this.calculateViewOrder()));
        }
        this.m_contributionHolder = new ContributionComposite(this);
        for (ICode<T> childCode : this.interceptCreateChildCodes()) {
            this.addChildCodeInternal(-1, childCode);
        }
    }

    protected ICodeExtension<T, ? extends AbstractCode<T>> createLocalExtension() {
        return new LocalCodeExtension(this);
    }

    public final List<? extends ICodeExtension<T, ? extends AbstractCode<T>>> getAllExtensions() {
        return this.m_objectExtensions.getAllExtensions();
    }

    public <E extends IExtension<?>> E getExtension(Class<E> c) {
        return this.m_objectExtensions.getExtension(c);
    }

    @ConfigOperation
    protected List<? extends ICode<T>> execCreateChildCodes() {
        List<Class<ICode>> configuredCodes = this.getConfiguredCodes();
        List<ICode> contributedCodes = this.m_contributionHolder.getContributionsByClass(ICode.class);
        ArrayList<ICode> codes = new ArrayList<ICode>(configuredCodes.size() + contributedCodes.size());
        for (Class<ICode> codeClazz : configuredCodes) {
            ICode code = (ICode)ConfigurationUtility.newInnerInstance((Object)this, codeClazz);
            codes.add(code);
        }
        for (ICode c : contributedCodes) {
            codes.add(c);
        }
        codes.sort((Comparator<ICode>)new OrderedComparator());
        return codes;
    }

    protected ICodeRow<T> interceptCodeRow(ICodeRow<T> row) {
        return row;
    }

    @Override
    public T getId() {
        return (T)this.m_row.getKey();
    }

    @Override
    public String getText() {
        return this.m_row.getText();
    }

    @Override
    public boolean isActive() {
        return this.m_row.isActive();
    }

    public void setActiveInternal(boolean b) {
        this.m_row.withActive(b);
    }

    @Override
    public boolean isEnabled() {
        return this.m_row.isEnabled();
    }

    public void setEnabledInternal(boolean b) {
        this.m_row.withEnabled(b);
    }

    @Override
    public String getIconId() {
        String id = this.m_row.getIconId();
        if (id == null && this.m_codeType != null) {
            id = this.m_codeType.getIconId();
        }
        return id;
    }

    @Override
    public String getTooltipText() {
        return this.m_row.getTooltipText();
    }

    @Override
    public String getBackgroundColor() {
        return this.m_row.getBackgroundColor();
    }

    @Override
    public String getForegroundColor() {
        return this.m_row.getForegroundColor();
    }

    @Override
    public FontSpec getFont() {
        return this.m_row.getFont();
    }

    @Override
    public String getCssClass() {
        return this.m_row.getCssClass();
    }

    @Override
    public ICode<T> getParentCode() {
        return this.m_parentCode;
    }

    @Override
    public long getPartitionId() {
        return this.m_row.getPartitionId();
    }

    @Override
    public String getExtKey() {
        return this.m_row.getExtKey();
    }

    @Override
    public Number getValue() {
        return this.m_row.getValue();
    }

    public double getOrder() {
        return this.m_row.getOrder();
    }

    public void setOrder(double order) {
        this.m_row.withOrder(order);
    }

    @Override
    public List<? extends ICode<T>> getChildCodes() {
        return this.getChildCodes(true);
    }

    @Override
    public List<? extends ICode<T>> getChildCodes(boolean activeOnly) {
        if (this.m_codeList == null) {
            return new ArrayList(0);
        }
        ArrayList<ICode<T>> result = new ArrayList<ICode<T>>(this.m_codeList);
        if (activeOnly) {
            result.removeIf(tiCode -> !tiCode.isActive());
        }
        return result;
    }

    @Override
    public ICode<T> getChildCode(T id) {
        ICode<T> c = null;
        if (this.m_codeMap != null) {
            c = this.m_codeMap.get(id);
        }
        if (c == null) {
            if (this.m_codeList == null) {
                return null;
            }
            for (ICode<T> childCode : this.m_codeList) {
                c = childCode.getChildCode(id);
                if (c == null) continue;
                return c;
            }
        }
        return c;
    }

    @Override
    public ICode<T> getChildCodeByExtKey(Object extKey) {
        if (this.m_codeList == null || extKey == null) {
            return null;
        }
        for (ICode<T> childCode : this.m_codeList) {
            if (extKey.equals(childCode.getExtKey())) {
                return childCode;
            }
            ICode<T> c = childCode.getChildCodeByExtKey(extKey);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    @Override
    public ICodeType<?, T> getCodeType() {
        return this.m_codeType;
    }

    @Override
    public void addChildCodeInternal(int index, ICode<T> code) {
        if (code == null) {
            return;
        }
        int oldIndex = this.removeChildCodeInternal(code.getId());
        if (oldIndex >= 0 && index < 0) {
            index = oldIndex;
        }
        if (this.m_codeMap == null) {
            this.m_codeMap = new HashMap<T, ICode<T>>();
        }
        if (this.m_codeList == null) {
            this.m_codeList = new ArrayList<ICode<T>>();
        }
        code.setCodeTypeInternal(this.m_codeType);
        code.setParentCodeInternal(this);
        this.m_codeMap.put(code.getId(), code);
        if (index < 0) {
            this.m_codeList.add(code);
        } else {
            this.m_codeList.add(Math.min(index, this.m_codeList.size()), code);
        }
    }

    @Override
    public int removeChildCodeInternal(T codeId) {
        if (this.m_codeMap == null) {
            return -1;
        }
        ICode droppedCode = this.m_codeMap.remove(codeId);
        if (droppedCode == null) {
            return -1;
        }
        int index = -1;
        if (this.m_codeList != null) {
            Iterator<ICode<T>> it = this.m_codeList.iterator();
            while (it.hasNext()) {
                ++index;
                ICode<T> candidateCode = it.next();
                if (candidateCode != droppedCode) continue;
                it.remove();
                break;
            }
        }
        droppedCode.setCodeTypeInternal(null);
        droppedCode.setParentCodeInternal(null);
        return index;
    }

    @Override
    public void setParentCodeInternal(ICode<T> c) {
        this.m_parentCode = c;
    }

    @Override
    public void setCodeTypeInternal(ICodeType<?, T> type) {
        this.m_codeType = type;
        if (this.m_codeList != null) {
            for (ICode<T> c : this.m_codeList) {
                c.setCodeTypeInternal(type);
            }
        }
    }

    public String toString() {
        return "Code[id=" + String.valueOf(this.getId()) + ", text='" + this.getText() + "' " + (this.isActive() ? "active" : "inactive") + "]";
    }

    @Override
    public <CODE extends ICode<T>> boolean visit(ICodeVisitor<CODE> visitor, int level, boolean activeOnly) {
        List<ICode<T>> a = this.getChildCodes(activeOnly);
        for (ICode<T> childCode : a) {
            if (!visitor.visit(childCode, level)) {
                return false;
            }
            if (childCode.visit(visitor, level + 1, activeOnly)) continue;
            return false;
        }
        return true;
    }

    protected Object readResolve() throws ObjectStreamException {
        this.m_codeMap = new HashMap<T, ICode<T>>();
        if (this.m_codeList == null) {
            this.m_codeList = new ArrayList<ICode<T>>();
        } else {
            for (ICode<T> c : this.m_codeList) {
                this.m_codeMap.put(c.getId(), c);
                c.setParentCodeInternal(this);
            }
        }
        return this;
    }

    @Override
    public ICodeRow<T> toCodeRow() {
        return new CodeRow<T>(this.m_row);
    }

    public String classId() {
        return ConfigurationUtility.getAnnotatedClassIdWithFallback(this.getClass());
    }

    @Override
    public CodeDo toDo() {
        return (CodeDo)((ToDoFunctionHelper)BEANS.get(ToDoFunctionHelper.class)).toDo((Object)this, ICodeToDoFunction.class);
    }

    protected final List<? extends ICode<T>> interceptCreateChildCodes() {
        List<ICodeExtension<T, AbstractCode<T>>> extensions = this.getAllExtensions();
        CodeChains.CodeCreateChildCodesChain<T> chain = new CodeChains.CodeCreateChildCodesChain<T>(extensions);
        return chain.execCreateChildCodes();
    }

    protected static class LocalCodeExtension<T, OWNER extends AbstractCode<T>>
    extends AbstractSerializableExtension<OWNER>
    implements ICodeExtension<T, OWNER> {
        private static final long serialVersionUID = 1L;

        public LocalCodeExtension(OWNER owner) {
            super(owner);
        }

        @Override
        public List<? extends ICode<T>> execCreateChildCodes(CodeChains.CodeCreateChildCodesChain<T> chain) {
            return ((AbstractCode)this.getOwner()).execCreateChildCodes();
        }
    }
}

